PROGRAM PRZ5_6;
  {$IFDEF CPU87} {$N+}
         {$ELSE} {$N-}
  {$ENDIF}
  USES CRT,GRAPH,TFLOAT,ALGELIN,RORONLP,WYKRESY,PLIK_ZO,KOM_BLAD;
  VAR  X0,Y,B                                           :WEK;
       A                                                :MAC;
       W1,W2,W3                                         :WEKI;
       M,i                                              :WORD;
       N,sk                                             :BYTE;
       h,h0,TX,t0,t1,t,X,X1,X2,X3,X4,e1,e2,e3,e4,
       a1,a2,a3,a4,a5,b1,b2,b3,b4,c1,c2,wh,w,Usm,w0,be,
       p,Lrs,Lrw,Ms,Mw,Ls,Lw,Mws,MM,d,Rs,Rw,J,Mobc      :FLOAT;
       WYB,CH,CH1                                       :CHAR;
       N_PLIK                                           :DANE_NAZWY_PLIKU;
       BLAD                                             :BYTE;

  PROCEDURE DANE;
    BEGIN
      Usm:=220*SQRT(2) {V};
      w0:=100*PI; be:=PI/2;
      p:=2; { liczba par biegunow }
      Lrs:=0.0023; Ms:=0.0475; Lrw:=0.000887;  Mw:=0.01832;
      Ls:=Lrs+1.5*Ms ; Lw:=Lrw+1.5*Mw;
      Mws:=0.0295 {H};   MM:=3*Mws/2;  d:=Ls*Lw-SQR(MM);
      Rs:=0.3747 {OM}; Rw:=0.112 {OM};
      J:=1 {kg m2};  wh:=0.01;
      X0[1]:=0; X0[2]:=0; X0[3]:=0; X0[4]:=0 ; X0[5]:=0;
      Mobc:=5.0 {Nm};
    END {DANE};

  PROCEDURE OBLICZENIAPOMOCNICZE;
    { Obliczanie wspolczynnikow (5.239) ukladu rownan (5.238) }
    VAR u1,u2:FLOAT;
    BEGIN
      d:=Ls*Lw-SQR(MM);
      a1:=Rs*Lw/d;  a2:=Rs*MM/d; a3:=Rw*Ls/d; a4:=Rw*MM/d; a5:=w0;
      b1:=p*Ls*Lw/d;  b4:=p*SQR(MM)/d; b2:=p*Ls*MM/d; b3:=p*Lw*MM/d;
      c2:=wh/J; c1:=p*MM/J;
      u1:=1.5*Usm*SIN(be); u2:=1.5*Usm*COS(be);
      e1:=Lw*u1/d; e2:=Lw*u2/d; e3:=MM*u1/d; e4:=MM*u2/d;
    END { OBLICZENIAPOMOCNICZE };

   PROCEDURE F(VAR Y:WEK; X:WEK; t:FLOAT;N:BYTE); FAR;
     { Generacja wektora prawej strony ukladu rownan (5.238) }
     BEGIN
       Y[1]:=-a1*X[1]-a5*X[2]+a4*X[3]-b4*X[2]*X[5]-b3*X[4]*X[5]+e1;
       Y[2]:=a5*X[1]-a1*X[2]+a4*X[4]+b4*X[1]*X[5]+b3*X[3]*X[5]+e2;
       Y[3]:=a2*X[1]-a3*X[3]-a5*X[4]+b2*X[2]*X[5]+b1*X[4]*X[5]-e3;
       Y[4]:=a2*X[2]+a5*X[3]-a3*X[4]-b2*X[1]*X[5]-b1*X[3]*X[5]-e4;
       Y[5]:=-c2*X[5]+c1*(X[1]*X[4]-X[3]*X[2])-Mobc/J
     END {F};

   PROCEDURE GENMAC;
   { Generacja macierzy ukladu rownan liniowych otrzymanych z przyrowna- }
   { nia prawej strony ukladu rowna rozniczkowych (5.238) do zera dla    }
   { x5=w  niezbedna do obliczen stanu ustalonego silnika dla stalej     }
   { predkosci x5=w                                                      }
     BEGIN
       A[1,1]:=-a1;     A[1,2]:=-a5-b4*w; A[1,3]:=a4 ;     A[1,4]:=-b3*w;    B[1]:=-e1;
       A[2,1]:=a5+b4*w; A[2,2]:=-a1;      A[2,3]:=b3*w;    A[2,4]:=a4;       B[2]:=-e2;
       A[3,1]:=a2;      A[3,2]:=b2*w;     A[3,3]:=-a3;     A[3,4]:=-a5+b1*w; B[3]:=e3;
       A[4,1]:=-b2*w;   A[4,2]:=a2;       A[4,3]:=a5-b1*w; A[4,4]:=-a3;      B[4]:=e4
     END {GENMAC};

   PROCEDURE MENU;
     BEGIN
       CLRSCR;
       GOTOXY(1, 5); WRITE('Prezentacja graficzna stanu nieustalonego'+
                           ' silnika asynchronicznego ');
       GOTOXY(1, 7); WRITE(' 1 - prad stojana x1 w ukladzie wspolrzednych wirnika');
       GOTOXY(1, 8); WRITE(' 2 - prad stojana x2 w ukladzie wspolrzednych wirnika');
       GOTOXY(1, 9); WRITE(' 3 - prad wirnika x3 w ukladzie wspolrzednych wirnika');
       GOTOXY(1,10); WRITE(' 4 - prad wirnika x4 w ukladzie wspolrzednych wirnika');
       GOTOXY(1,11); WRITE(' 5 - predkosc katowa wirnika');
       GOTOXY(1,12); WRITE(' M - dynamiczny moment elektromagnetyczny silnika');
       GOTOXY(1,13); WRITE(' E - statyczny moment elektromagnetyczny silnika');
       GOTOXY(1,14); WRITE(' S - plaszczyzna fazowa pradow stojana');
       GOTOXY(1,15); WRITE(' W - plaszczyzna fazowa pradow wirnika');
       GOTOXY(1,17); WRITE(' K - koniec wyboru')
    END { MENU };

BEGIN  {Czesc operacyjna programu}
  INIC_PLIK(N_PLIK);
  t1:=1.2; N:=5 ; t0:=0.0;  h0:=(t1-t0)/1000;
  CLRSCR;
  DANE;
  OBLICZENIAPOMOCNICZE;
  WRITE('M= ');
  MET_FEHLB(2,4,N,F,h0,t0,t1,1e-6,1e-8,1E-6,X0,M,N_PLIK,BLAD,10*256+1);
  IF BLAD<>0 THEN
  BEGIN
    PISZ_KOM_BLAD(BLAD);
    HALT
  END;
  CH1:='B';
  ODCZYT_D(X,N,M,CH1,N_PLIK,0,0,BLAD);
  IF BLAD<>0 THEN
  BEGIN
    PISZ_KOM_BLAD(BLAD);
    HALT
  END;
  CH1:='C';
  FOR i:=0 TO M DO
  BEGIN
    ODCZYT_D(X,N,M,CH1,N_PLIK,0,i,BLAD);
    W1[i]:=X*1000
  END;
  REPEAT
    CLRSCR;
    MENU;
    WYB:=UPCASE(READKEY);
    CASE WYB OF
      '1': BEGIN
             FOR i:=0 TO M DO
               ODCZYT_D(W2[i],N,M,CH1,N_PLIK,1,i,BLAD);
             WYKRESXYG(W1,W2,M,' Przebieg pradu stojana x1 w ukladzie wspolrzednych wirnika ',
                                '','t [msek]','i1(t) [A]')
           END { 1 };
      '2': BEGIN
             FOR i:=0 TO M DO
               ODCZYT_D(W2[i],N,M,CH1,N_PLIK,2,i,BLAD);
             WYKRESXYG(W1,W2,M,' Przebieg pradu stojana x2 w ukladzie wspolrzednych wirnika ',
                       '','t [msek]','i2(t) [A]')
           END { 2 };
      '3': BEGIN
             FOR i:=0 TO M DO
               ODCZYT_D(W2[i],N,M,CH1,N_PLIK,3,i,BLAD);
             WYKRESXYG(W1,W2,M,' Przebieg pradu wirnika x3 w ukladzie wspolrzednych wirnika ',
                       '','t [msek]','i3(t) [A]')
           END { 3 };
      '4': BEGIN
             FOR i:=0 TO M DO
               ODCZYT_D(W2[i],N,M,CH1,N_PLIK,4,i,BLAD);
             WYKRESXYG(W1,W2,M,' Przebieg pradu wirnika x4 w ukladzie wspolrzednych wirnika ',
                       '','t [msek]','i4(t) [A]')
           END { 4 };
      '5': BEGIN
             FOR i:=0 TO M DO
             BEGIN
               ODCZYT_D(X,N,M,CH1,N_PLIK,5,i,BLAD);
               W2[i]:=X/(2*PI)
             END;
             WYKRESXYG(W1,W2,M,' Przebieg predkosci wirnika ',
                       '','t [msek]','w(t) [obr/sek]')
           END {4};
      'M': BEGIN
             FOR i:=0 TO M DO
             BEGIN
               ODCZYT_D(X1,N,M,CH1,N_PLIK,1,i,BLAD);
               ODCZYT_D(X2,N,M,CH1,N_PLIK,2,i,BLAD);
               ODCZYT_D(X3,N,M,CH1,N_PLIK,3,i,BLAD);
               ODCZYT_D(X4,N,M,CH1,N_PLIK,4,i,BLAD);
               W2[i]:=p*MM*(X1*X4-X2*X3);
               ODCZYT_D(X4,N,M,CH1,N_PLIK,5,i,BLAD);
               W3[i]:=X4/(2*PI);
             END;
             WYKRESXYG(W3,W2,M,' Przebieg momentu elektromagnetycznego'+
                       ' silnika asynchronicznego','','n [obr/sek]','M(t) [Nm]')
            END {M};
       'E': BEGIN
              FOR i:=0 TO 200 DO
              BEGIN
                w:=i*w0/200/p;
                GENMAC;
                RRAL(A,B,Y,4,1E-8,BLAD);
                W3[i]:=60*w/(2*PI);
                W2[i]:=p*MM*(Y[1]*Y[4]-Y[2]*Y[3])
              END;
              WYKRESXYG(W3,W2,200,' Charakterystyka statyczna momentu silnika'+
                        ' asynchronicznego','','n [obr/min]','M [Nm]')
            END {E};
       'S': BEGIN
              FOR i:=0 TO M DO
              BEGIN
                ODCZYT_D(W3[i],N,M,CH1,N_PLIK,1,i,BLAD);
                ODCZYT_D(W2[i],N,M,CH1,N_PLIK,2,i,BLAD)
              END;
              WYKRESXYG(W3,W2,M,' Plaszczyzna fazowa pradow stojana '+
                        ' silnika asynchronicznego','','i1 [A]','i2(t) [A]')
            END {S};
       'W': BEGIN
              FOR i:=0 TO M DO
              BEGIN
                ODCZYT_D(W3[i],N,M,CH1,N_PLIK,3,i,BLAD);
                ODCZYT_D(W2[i],N,M,CH1,N_PLIK,4,i,BLAD)
              END;
              WYKRESXYG(W3,W2,M,' Plaszczyzna fazowa pradow wirnika '+
                        ' silnika asynchronicznego','','i3 [A]','i4(t) [A]')
            END {W}
    END;
  UNTIL WYB='K';
  CH1:='E';
  ODCZYT_D(X1,N,M,CH1,N_PLIK,0,0,BLAD)
END.
