PROGRAM PRZ1_3;

{$IFDEF CPU87} {$N+}
       {$ELSE} {$N-}
{$ENDIF}

USES CRT,TFLOAT,ALGELIND,KOM_BLAD;
TYPE GALAZ = RECORD    { Typ galeziowy do zapisu danych w poszczegolnych galeziach }
               Wp,            { wezel poczatkowy galezi       }
               Wk :BYTE;      { wezel koncowy galezi          }
               G,             { konduktancja galezi           }
               E  :REAL       { sila elektromotoryczna galezi }
             END;
     { Zapis danych galeziowych w postaci wektora             }
     DANEGALAZ    = ARRAY[PMAXD] OF GALAZ;
VAR  k,l,m,Lg,Lw  :PMAXD;
     Ig           :REAL;
     D            :DANEGALAZ;
     B,V          :WEKD;
     G            :MACD;
     BLAD         :BYTE;
     WYB,KEY      :CHAR;

PROCEDURE PISZ_DANE_UKLADU;
{ w postaci zmiennej D dla poszczegolnych galezi }
  VAR k :PMAXD;
  BEGIN
    CLRSCR;
    WRITELN('  Wprowadz dane galeziowe ukladu elektrycznego ');
    WRITELN(' ----------------------------------------------');
    WRITE('Podaj liczbe galezi ukladu Lg= '); READ(Lg);
    WRITE('Podaj liczbe wezlow ukladu Lw= '); READ(Lw);
    WRITELN;
    FOR k:=1 TO Lg DO
    BEGIN
      WRITELN(' Galaz nr ',k:2,'.');
      WRITELN('------------  ');
      WRITE('   - orientacja od wezla nr= '); READ(D[k].Wp);
      WRITE('                do wezla nr= '); READ(D[k].Wk);
      WRITE('   - SEM [V]          E(',k:2,')='); READ(D[k].E);
      WRITE('   - konduktancja [S]  G(',k,')='); READ(D[k].G);
      WRITELN
    END
  END { PISZ_DANE_UKLADU };

PROCEDURE GENERACJA_ROWNANIA(VAR G:MACD; VAR B:WEKD);
{ G*V=B  metoda potencjalow Coltriego wg wzoru (1.107) (1.108) }
  VAR k,l,m:PMAXD;
  BEGIN
    FOR k:=1 TO Lw-1 DO
    BEGIN
      B[k]:=0;            { Zerowanie wektora B  }
      FOR l:=1 TO Lw-1 DO
        G[k]^[l]:=0       { Zerowanie macierzy G }
    END;
    FOR m:=1 TO Lg DO
    BEGIN
      k:=D[m].Wp;  l:=D[m].Wk;
      IF k=Lw             { warunek (1.109c)      }
        THEN BEGIN
               B[l]:=B[l]+D[m].E*D[m].G;
               G[l]^[l]:=G[l]^[l]+D[m].G
             END
        ELSE IF l=Lw      { warunek (1.109d)      }
               THEN BEGIN
                      B[k]:=B[k]-D[m].E*D[m].G;
                      G[k]^[k]:=G[k]^[k]+D[m].G
                    END
               ELSE BEGIN { warunki (1.109a,b)    }
                      B[k]:=B[k]-D[m].E*D[m].G;
                      B[l]:=B[l]+D[m].E*D[m].G;
                      G[l]^[l]:=G[l]^[l]+D[m].G;
                      G[k]^[k]:=G[k]^[k]+D[m].G;
                      G[k]^[l]:=-D[m].G;
                      G[l]^[k]:=-D[m].G
                    END
    END
  END { GENERACJA_ROWNANIA };

PROCEDURE MENU;
  BEGIN
    CLRSCR;
    WRITELN('       Obliczenia ukladu elektrycznego'); WRITELN;
    WRITELN('            V - rozklad potencjalow');
    WRITELN('            I - rozplyw pradow');
    WRITELN('            K - koniec wyboru')
  END { MENU };

BEGIN { Blok glowny programu }
  PISZ_DANE_UKLADU;
  NEWMACD(G,Lw-1,BLAD); { Tworzenie macierzy dynamicznej G na stercie }
  IF BLAD<>0
    THEN BEGIN
           CLRSCR;
           PISZ_KOM_BLAD(BLAD)
         END
    ELSE BEGIN
           GENERACJA_ROWNANIA(G,B);
           RRALD(G,B,V,Lw-1,1E-16,BLAD); { Rozwiazywanie ukladu rownan pkt 1.18 }
           IF BLAD<>0
             THEN BEGIN
                    CLRSCR;
                    PISZ_KOM_BLAD(BLAD)
                  END
             ELSE BEGIN
                    V[Lw]:=0;       { Potencjal wezla o numerze Lw przyjmuje sie jako zerowy }
                    REPEAT
                      CLRSCR;
                      MENU;
                      WYB:=UPCASE(READKEY);
                      CLRSCR;
                      CASE WYB OF
                        'V': BEGIN
                                WRITELN('Rozklad potencjalow ukladu:');
                                FOR k:=1 TO Lw DO
                                  WRITELN('V[',k,']=',V[k]:12:6);
                                KEY:=READKEY
                              END; { V }
                         'I': BEGIN
                                WRITELN('Rozplyw pradow ukladu:');
                                FOR m:=1 TO Lg DO
                                BEGIN
                                  k:=D[m].Wp;  l:=D[m].Wk;
                                  Ig:=(V[k]-V[l]+D[m].E)*D[m].G;
                                  WRITELN('I[',m,']=',Ig:12:6)
                                END;
                                KEY:=READKEY
                              END { I }
                      END
                    UNTIL WYB='K'
                  END
         END
END.
