{***************************************************************************}
{                        Modul FOURIER                                      }
{            SZEREGI FOURIERA I TRANSFORMACJA FOURIERA                      }
{                  Turbo Pascal  wersja 7.0                                 }
{                     autor Bernard Baron                                   }
{***************************************************************************}
 UNIT FOURIER;

 INTERFACE
  {$F+}
  {$IFDEF CPU87} {$N+}
         {$ELSE} {$N-}
  {$ENDIF}
   USES TFLOAT,ALGEZES;

   CONST MAXP   =1024;
   TYPE  WEK2   =ARRAY[0..MAXP] OF FLOAT;
         WEKD2  =^WEK2;
         WEKZ2  =ARRAY[0..MAXP] OF ZESPOL;
         WEKZD2 =^WEKZ2;
         FUNX   =FUNCTION(X:FLOAT):FLOAT;
         PROCYW =PROCEDURE(VAR Y:ZESPOL; w:FLOAT);


   FUNCTION POTEGA2(P:BYTE):WORD;
   {  Obliczanie 2 do potegi P  tj. 2^P }

   PROCEDURE WEKEXPW(VAR EXPW :WEKZD2;
                         N,q  :INTEGER);
{----------------------------------------------------------------}
{ Rekurencyjne wyznacznie wartosci funkcji wykladniczej o argu - }
{ mencie zespolonym w postaci wektora o elementach zespolonych   }
{ EXPW^[k] =EXP(-j*2*PI*k/N) ; k = 0,1,2,...,N-1                 }
{ q = -1  - transformacja prosta; q =1  - transformacja odwrotna }
{ EXPW^[k+1] = EXPW^[k]*W  gdzie  W = EXP(q*j*2*PI/N)            }
{----------------------------------------------------------------}

   PROCEDURE COOLEY_TUKEY(VAR F,EXPW :WEKZD2;
                              p      :BYTE;
                          VAR BLAD   :BYTE);
{-----------------------------------------------------------------}
{ Szybki algorytm przeksztalcenia Fouriera - wg. Cooleya- Tukeya  }
{ Fast Fourier Transform Cooleya-Tukeya wg wzorow (7.81) (7.82)   }
{ F - zmienna wskazujaca wektor probek zespolonych F^[i]          }
{                              p                                  }
{    i = 0,1,2,...N-1  ;  N = 2  ;   p - wykladnik potegi         }
{ F^[i].RE - czesc rzeczywista i - tej probki                     }
{ F^[i].IM - czesc urojona i - tej probki                         }
{                                        r                        }
{ EXPW- zmienna wskazujaca wektor poteg W generowany jak          }
{       w procedurze WEKEXPW                                      }
{ Zespolone wspolczynniki dyskretnej transformacji Fouriera       }
{ wyprowadzone na zewnatrz procedury pod postacia tej             }
{ samej zmiennej co wektor probek wejsciowych F^[i]               }
{ BLAD    - nr bledu; 0 - brak bledu                              }
{-----------------------------------------------------------------}

   PROCEDURE FFTCT(VAR F    :WEKZD2;
                       p,q  :INTEGER;
                   VAR BLAD :BYTE);
{-----------------------------------------------------------------}
{ Szybki algorytm przeksztalcenia Fouriera - wg. Cooleya- Tukeya  }
{      Fast Fourier Transform Cooleya-Tukeya                      }
{ F - zmienna wskazujaca wektor probek zespolonych F^[i]          }
{                              p                                  }
{    i = 0,1,2,...N-1  ;  N = 2  ;   p - wykladnik potegi         }
{ q = -1  - transformacja prosta;  q =1  - transformacja odwrotna }
{ F^[i].RE - czesc rzeczywista i - tej probki                     }
{ F^[i].IM - czesc urojona i - tej probki                         }
{ Zespolone wspolczynniki dyskretnej transformacji Fouriera       }
{ wyprowadzone na zewnatrz procedury FFTCT pod postacia tej       }
{ samej zmiennej co wektor probek wejsciowych F^[i]               }
{ BLAD    - nr bledu; 0 - brak bledu                              }
{-----------------------------------------------------------------}

  PROCEDURE SANDE_TUKEY(VAR F,EXPW :WEKZD2;
                            p      :BYTE;
                        VAR BLAD   :BYTE);
{-----------------------------------------------------------------}
{ Szybki algorytm przeksztalcenia Fouriera - wg. Sande'a- Tukeya  }
{ Fast Fourier Transform Sande-Tukeya wg wzorow (7.96) (7.97)     }
{ F - zmienna wskazujaca wektor probek zespolonych F^[i]          }
{                              p                                  }
{    i = 0,1,2,...N-1  ;  N = 2  ;   p - wykladnik potegi         }
{ F^[i].RE - czesc rzeczywista i - tej probki                     }
{ F^[i].IM - czesc urojona i - tej probki                         }
{                                        r                        }
{ EXPW- zmienna wskazujaca wektor poteg W generowany jak          }
{       w procedurz WEKEXPW  pkt. (7.1)                           }
{ Zespolone wspolczynniki dyskretnej transformacji Fouriera       }
{ wyprowadzone na zewnatrz procedury pod postacia tej             }
{ samej zmiennej co wektor probek wejsciowych F^[i]               }
{ BLAD    - nr bledu; 0 - brak bledu                              }
{-----------------------------------------------------------------}

  PROCEDURE FFTST(VAR F    :WEKZD2;
                      p,q  :INTEGER;
                  VAR BLAD :BYTE);
{-----------------------------------------------------------------}
{ Szybki algorytm przeksztalcenia Fouriera - wg. Sande'a- Tukeya  }
{      Fast Fourier Transform Sande-Tukeya                        }
{ F - zmienna wskazujaca wektor probek zespolonych F^[i]          }
{                              p                                  }
{    i = 0,1,2,...N-1  ;  N = 2  ;   p - wykladnik potegi         }
{ q = -1  - transformacja prosta;  q =1  - transformacja odwrotna }
{ F^[i].RE - czesc rzeczywista i - tej probki                     }
{ F^[i].IM - czesc urojona i - tej probki                         }
{ Zespolone wspolczynniki dyskretnej transformacji Fouriera       }
{ wyprowadzone na zewnatrz procedury FFTST pod postacia tej       }
{ samej zmiennej co wektor probek wejsciowych F^[i]               }
{ BLAD    - nr bledu; 0 - brak bledu                              }
{-----------------------------------------------------------------}

  PROCEDURE OWSFMCT(    U    :FUNX;
                        t0,T :FLOAT;
                    VAR F    :WEKZD2;
                        p    :BYTE;
                    VAR BLAD :BYTE);
{----------------------------------------------------------------}
{ Szybki algorytm przeksztalcenia Fouriera - wg. Cooleya Tukeya  }
{ zastosowany do funkcji okresowej U(t) o okresie T danej        }
{ analitycznie w przedziale (t0,t0+T)  typ funkcyjny  U:FUNX     }
{ F - zmienna wskazujaca zespolony wektor F^[i] wspolczynnikow   }
{     szeregu Fouriera                                           }
{                           p                                    }
{ i = 0,1,2,...N-1  ;  N = 2  ;   p - wykladnik potegi           }
{ F^[i].RE - czesc rzeczywista i - tego wspolczynnika            }
{ F^[i].IM - czesc urojona i - tego wspolczynika                 }
{ Stosowanie procedury wymaga wstepnej inicjacji wektora         }
{ dynamicznego F^ procedura NEW(F)                               }
{ BLAD    - nr bledu; 0 - brak bledu                             }
{----------------------------------------------------------------}

  PROCEDURE OWSFMST(    U    :FUNX;
                        t0,T :FLOAT;
                    VAR F    :WEKZD2;
                        p    :BYTE;
                    VAR BLAD :BYTE);
{----------------------------------------------------------------}
{ Szybki algorytm przeksztalcenia Fouriera - wg. Sande'a Tukeya  }
{ zastosowany do funkcji okresowej U(t) o okresie T danej        }
{ analitycznie w przedziale (t0,t0+T)  typ funkcyjny  U:FUNX     }
{ F - zmienna wskazujaca zespolony wektor F^[i] wspolczynnikow   }
{     szeregu Fouriera                                           }
{                           p                                    }
{ i = 0,1,2,...N-1  ;  N = 2  ;   p - wykladnik potegi           }
{ F^[i].RE - czesc rzeczywista i - tego wspolczynnika            }
{ F^[i].IM - czesc urojona i - tego wspolczynika                 }
{ Stosowanie procedury wymaga wstepnej inicjacji wektora         }
{ dynamicznego F^ procedura NEW(F)                               }
{ BLAD    - nr bledu; 0 - brak bledu                             }
{----------------------------------------------------------------}

  PROCEDURE ODW_TRAN_FOU(    TRAN  :PROCYW;
                             w0    :FLOAT;
                         VAR T0,dt :FLOAT;
                         VAR Ep,El :WEKD2;
                             p     :BYTE;
                         VAR N     :WORD;
                         VAR BLAD  :BYTE);
{----------------------------------------------------------------}
{ Obliczanie odwrotnej transformacji Fouriera dla dowolnie zada- }
{ nej transformaty w postaci funkcji zespolone Y(w) argumentu    }
{ rzeczywistego w,wyznaczanej w procedurze typu PROCYW           }
{ w0 - okresla przedzial calkowania ze wzgledu na zmienna        }
{      w<=(-w0,+w0)                                              }
{ p - wykladnik potegi                                           }
{      p                                                         }
{ N = 2  -ilosc chwil czasowych dla ktorych oblicza sie wartosci }
{         oryginalu                                              }
{ Ep^ - wektor wartosci oryginalu o skladowych Ep^[i] dla        }
{       i = 0,1,2,...,N-1, oraz czasow dodatnich t=i*dt gdzie    }
{ dt=pi/w0 - przyrost czasu                                      }
{ El^ - wektor wartosci oryginalu o skladowych El^[i] dla        }
{       i = 1,2,...,N-1, oraz czasow ujemnych  t=-i*dt gdzie     }
{       dt=pi/w0                                                 }
{ T0 - okresla przedzial czasowy w ktorym oblicza sie oryginal   }
{      t<=(-T0,+T0)                                              }
{ BLAD    - nr bledu; 0 - brak bledu                             }
{----------------------------------------------------------------}

  PROCEDURE FTHORNER(VAR F,C  :WEKZD2;
                         N,q  :INTEGER;
                     VAR BLAD :BYTE);
{----------------------------------------------------------------}
{ Dyskretne przeksztalcenie Fouriera w wersji zespolonej wedlug  }
{     algorytmu Hornera (7.39) (7.40) zgodnie z wzorami (7.28)   }
{     dla transformacji prostej oraz (7.32) dla trans. odwrotnej }
{ F - zmienna wskazujaca wektor probek zespolonych F^[i]         }
{ C - zmienna wskazujaca wektor zespolonych wspolczynnikow przek-}
{    sztalcenia Fouriera jako wynik dzialania procedury FTHORNER }
{ N - ilosc elementow wektorow F , C     ;   i = 0,1,2,...N-1    }
{ q = -1  - transformacja prosta; q =1  - transformacja odwrotna }
{ BLAD    - nr bledu; 0 - brak bledu                             }
{----------------------------------------------------------------}

  PROCEDURE FTHORNER_FUN(    U    :FUNX;
                             t0,T :FLOAT;
                         VAR F    :WEKZD2;
                             N,M  :INTEGER;
                         VAR BLAD :BYTE);
{----------------------------------------------------------------}
{ Dyskretne przeksztalcenie Fouriera w wersji zespolonej wedlug  }
{ algorytmu Hornera (7.39) zastosowany do funkcji okresowej U(t) }
{ o okresie T danej analitycznie w przedziale (t0,t0+T)          }
{ U:FUNX typ funkcyjny (7.45)                                    }
{ T - okres funkcji U(t)                                         }
{ t0- okresla chwile poczatkowa calkowania                       }
{ F - zmienna wskazujaca zespolony wektor F^[i] wspolczynnikow   }
{     szeregu Fouriera                                           }
{ N - ilosc wspolczynnikow zespolonego szeregu Fouriera          }
{ M - ilosc probek funkcji U(t)                                  }
{ F^[i].RE - czesc rzeczywista i - tego wspolczynnika            }
{ F^[i].IM - czesc urojona i - tego wspolczynika                 }
{ Stosowanie procedury wymaga wstepnej inicjacji wektora         }
{ dynamicznego F^ procedura NEW(F)                               }
{ BLAD    - nr bledu; 0 - brak bledu                             }
{----------------------------------------------------------------}

 IMPLEMENTATION


   FUNCTION POTEGA2;
     BEGIN
       POTEGA2:=1 SHL p
     END { POTEGA2 };

   PROCEDURE WEKEXPW(VAR EXPW:WEKZD2; N,q:INTEGER);
     VAR k  :INTEGER;
         FI :FLOAT;
         W  :ZESPOL;
     BEGIN
       FI:=2*PI/N;
       W.RE:=COS(FI);    W.IM:=q*SIN(FI);
       EXPW^[0].RE:=1.0; EXPW^[0].IM:=0.0;
       FOR k:=1 TO N-1 DO
         MUL(EXPW^[k],EXPW^[k-1],W)
     END { WEKEXPW };

    PROCEDURE INVERBIT(VAR F:WEKZD2; N:INTEGER);
{----------------------------------------------------------------}
{ Zgodnie z algorytmem Cooleya-Tukeya wymagane jest odwrotne     }
{ uporzadkowanie bitow wskaznikow probek F^[j] (j=0,1,2,...,N-1 )}
{  np.  dla p=4  probka  nr. k=5=(0101) zostaje zamieniona       }
{  z l=(1010)=10                                                 }
{----------------------------------------------------------------}
       VAR i,j,k,NP2 :INTEGER;
           T         :ZESPOL;
       BEGIN
         NP2:=N SHR 1;
         i:=0;
         FOR j:=0 TO N-2 DO
         BEGIN
           IF j<i THEN
           BEGIN
             T:=F^[i]; F^[i]:=F^[j]; F^[j]:=T
           END;
           k:=NP2;
           WHILE k <= i DO
           BEGIN
             i:=i-k;
             k:=k SHR 1
           END;
           i:=i+k
         END
       END { INVERBIT };

   PROCEDURE COOLEY_TUKEY;
     VAR T                       :ZESPOL;
         j,i,l,k,m,r,s,N,MP,MP1  :WORD;
     BEGIN
       BLAD:=0;
       IF (p<3) OR (p>10) THEN
       BEGIN
         BLAD:=130;
         EXIT
       END;
       N:=POTEGA2(p);
       INVERBIT(F,N);
       r:=N;
       FOR m:=1 TO p DO
       BEGIN
         IF m>1
           THEN MP:=MP SHL 1
           ELSE MP:=2;
         MP1:=MP SHR 1;
         r:= r SHR 1;
         FOR k:=0 TO MP1-1 DO
         BEGIN
           i:=k; s:=r*k;
           WHILE i<N DO
           BEGIN
             l:=i+MP1;
             MUL(T,F^[l],EXPW^[s]);
             SUB(F^[l],F^[i],T);
             ADD(F^[i],F^[i],T);
             i:=i+MP
           END
         END
       END
     END { COOLEY_TUKEY };

   PROCEDURE FFTCT;
     VAR N     :WORD;
         EXPW  :WEKZD2;
     BEGIN
       BLAD:=0;
       IF (q<>1) AND (q<>-1)
         THEN BLAD:=131
         ELSE IF (p<3) OR (p>10)
                THEN BLAD:=132
                ELSE BEGIN
                       N:=POTEGA2(p);
                       NEW(EXPW);
                       WEKEXPW(EXPW,N,q);
                       COOLEY_TUKEY(F,EXPW,p,BLAD);
                       DISPOSE(EXPW)
                     END
     END { FFTCT };

   PROCEDURE SANDE_TUKEY;
     VAR T                      :ZESPOL;
         j,i,l,k,m,r,s,N,MP,MP1 :WORD;
     BEGIN
       BLAD:=0;
       IF (p<3) OR (p>10) THEN
       BEGIN
         BLAD:=133;
         EXIT
       END;
       N:=POTEGA2(p);
       MP1:=N;
       FOR m:=1 TO p DO
       BEGIN
         MP1:=MP1 SHR 1;
         MP:=MP1 SHL 1;
         IF m=1
           THEN r:=1
           ELSE r:=r SHL 1;
         FOR i:=0 TO MP1-1 DO
         BEGIN
           l:=i;  s:=i*r;
           WHILE l<N DO
           BEGIN
             k:=l+MP1;
             SUB(T,F^[l],F^[k]);
             ADD(F^[l],F^[l],F^[k]);
             MUL(F^[k],T,EXPW^[s]);
             l:=l+MP
           END
         END
       END;
       INVERBIT(F,N)
     END { SANDE_TUKEY };

   PROCEDURE FFTST;
     VAR N     :WORD;
         EXPW  :WEKZD2;
     BEGIN
       BLAD:=0;
       IF (q<>1) AND (q<>-1)
         THEN BLAD:=134
         ELSE IF (p<3) OR (p>10)
                THEN BLAD:=135
                ELSE BEGIN
                       N:=POTEGA2(p);
                       NEW(EXPW);
                       WEKEXPW(EXPW,N,q);
                       SANDE_TUKEY(F,EXPW,p,BLAD);
                       DISPOSE(EXPW)
                     END
     END { FFTST };

  PROCEDURE OWSFMCT;
    VAR  k,N     :WORD;
         la,h,tt :FLOAT;
    BEGIN
      N:=POTEGA2(p); h:=T/N; la:=2/N;
      FOR k:=0 TO N-1 DO
      BEGIN
        tt:=t0+k*h;
        F^[k].RE:=U(tt)*la; F^[k].IM:=0;
      END;
      FFTCT(F,p,-1,BLAD)
    END { OWSFMCT };

  PROCEDURE OWSFMST;
    VAR  k,N     :WORD;
         la,h,tt :FLOAT;
    BEGIN
      N:=POTEGA2(p); h:=T/N; la:=2/N;
      FOR k:=0 TO N-1 DO
      BEGIN
        tt:=t0+k*h;
        F^[k].RE:=U(tt)*la; F^[k].IM:=0;
      END;
      FFTST(F,p,-1,BLAD)
    END { OWSFMST };

  PROCEDURE ODW_TRAN_FOU;
    VAR  k,N1     :WORD;
         la,w,dw  :FLOAT;
         Y        :ZESPOL;
         F,G      :WEKZD2;
    BEGIN
      N:=POTEGA2(p); N1:=N SHR 1 ;
      dt:=PI/w0; T0:=N*dt; dw:=w0/N1; la:=1/(N*dt);
      NEW(F); NEW(G);
      FOR k:=0 TO N1-1 DO
      BEGIN
        w:=k*dw;  TRAN(Y,w);  MULRZ(F^[k],Y,la);
        IF k>0 THEN
        BEGIN
          TRAN(Y,-w);
          MULRZ(F^[N-k],Y,la);
        END;
      END;
      TRAN(Y,N1*dw);  MULRZ(F^[N1],Y,la);
      TRAN(Y,-N1*dw); MULRZ(Y,Y,la);  ADD(F^[N1],F^[N1],Y);
      G^:=F^;
      FFTCT(F,p,1,BLAD);
      IF BLAD=0 THEN
      BEGIN
        FFTCT(G,p,-1,BLAD);
        IF BLAD=0 THEN
          FOR k:=0 TO N-1 DO
          BEGIN
            Ep^[k]:=F^[k].RE;
            El^[k]:=G^[K].RE
          END
      END;
      DISPOSE(F); DISPOSE(G)
    END { ODW_TRAN_FOU };

   PROCEDURE FTHORNER;
     VAR i,k    :WORD;
         ZX,Wk  :ZESPOL;
         EXPW   :WEKZD2;
     BEGIN
       BLAD:=0;
       IF (q<>1) AND (q<>-1)
         THEN BLAD:=135
         ELSE IF N>1024
                THEN BLAD:=136
                ELSE BEGIN
                       NEW(EXPW);
                       WEKEXPW(EXPW,N,q);
                       FOR k:=0 TO N-1 DO
                       BEGIN
                         Wk:=EXPW^[k];  ZX:=F^[N-1];
                         FOR i:=N-1 DOWNTO 1 DO
                         BEGIN
                           MUL(ZX,ZX,Wk);
                           ADD(ZX,ZX,F^[i-1])
                         END;
                         C^[K]:=ZX
                       END;
                       DISPOSE(EXPW)
                     END
     END { FTHORNER };

  PROCEDURE FTHORNER_FUN;
    VAR  k,i     :WORD;
         la,h,tt :FLOAT;
         EXPW,C  :WEKZD2;
         ZX,Wk   :ZESPOL;
    BEGIN
      BLAD:=0;
      IF (N>1024) AND (M>1024) THEN
      BEGIN
        BLAD:=137;
        EXIT
      END;
      { Formowanie wektora probek dla zadanej funkcji okresowej U(T) }
      NEW(C);
      h:=T/M; la:=2/M;
      FOR k:=0 TO M-1 DO
      BEGIN
        tt:=t0+k*h;
        C^[k].RE:=U(tt)*la; C^[k].IM:=0;
      END {k};
      { Formowanie wektora zespolonego o skladowych typu (7.41) }
      NEW(EXPW);
      WEKEXPW(EXPW,M,-1);
      { Obliczanie zespolonych wspolczynnikow szeregu Fouriera  }
      { wg. algorytmu Hornera (7.40)                            }
      FOR k:=0 TO N-1 DO
      BEGIN
        Wk:=EXPW^[k];  ZX:=C^[M-1];
        FOR i:=M-1 DOWNTO 1 DO
        BEGIN
          MUL(ZX,ZX,Wk);
          ADD(ZX,ZX,C^[i-1])
        END;
        F^[K]:=ZX
      END;
      DISPOSE(C); DISPOSE(EXPW)
    END { FTHORNER_FUN };

END.