{*******************************************************************}
{                      Modul ALGMZESD                               }
{               ROWNANIA MACIERZOWE ZESPOLONE                       }
{                 dla macierzy dynamicznych                         }
{                  Turbo Pascal  wersja 7.0                         }
{                    autor Bernard Baron                            }
{*******************************************************************}
UNIT ALGMZESD;

{$IFDEF CPU87} {$N+}
       {$ELSE} {$N-}
{$ENDIF}


INTERFACE

USES  TFLOAT,ALGEZES;

CONST MAXD  =100;

TYPE  PMAXD =-1..MAXD;
      WEKZD =ARRAY[PMAXD]OF ZESPOL;
      MACZD =ARRAY[PMAXD]OF ^WEKZD;

PROCEDURE NEWMACZD(VAR A    :MACZD;
                       N    :LONGINT;
                   VAR BLAD :BYTE);
{ Utworzenie tablicy dynamicznej zespolonej A o N wierszach }
{  BLAD - nr bledu; 0 - brak bledu                          }

PROCEDURE DISMACZD(VAR A :MACZD;
                       N :BYTE);
{ Zwolnienie tablicy dynamicznej zespolonej A o N wierszach }

PROCEDURE TRANMACZD(VAR A,AT :MACZD;
                        M,N  :BYTE);
{ Wyznaczanie macierzy transponowanej At wzgledem macierzy zespolonej A  }
{ gdzie  M,N - odpowiednio liczba wierszy i kolumn macierzy A            }

PROCEDURE ADDMACZD(VAR C,A,B :MACZD;
                       M,N   :BYTE);
 { Wyznaczanie sumy macierzy zespolonych C=A+B }
 {  o M - wierszach i N - kolumnach }

PROCEDURE SUBMACZD(VAR C,A,B :MACZD;
                       M,N   :BYTE);
 { Wyznaczanie roznicy macierzy zespolonych C=A-B  }
 {  o M - wierszach i N - kolumnach }

PROCEDURE MULMACZD(VAR D,A,B :MACZD;
                       M,P,N :BYTE);
{ Wyznaczanie iloczynu macierzy  zespolonych D=A*B
  macierze  D - posiada M - wierszy i P - kolumn;
            A - posiada M - wierszy i N - kolumn;
            B - posiada N - wierszy i P - kolumn  }

PROCEDURE MULMACZZD(VAR A,B :MACZD;
                        z   :ZESPOL;
                        M,N :BYTE);
 { Iloczyn macierzy zespolonej B przez liczbe zespolona z tj. A=B*z }

PROCEDURE MACZEROZD(VAR A0  :MACZD;
                        N,M :BYTE);
{ Generacja macierzy zerowej zespolonej A0 o N wierszach i M kolumnach }

PROCEDURE MACJEDENZD(VAR A1 :MACZD;
                         N  :BYTE);
{ Generacja macierzy jednostkowej zespolonej A1 rzedu N }

PROCEDURE SKALROWZD(VAR A   :MACZD;
                    VAR B   :WEKZD;
                        N,M :BYTE);
{ Skalowanie macierzy zespolonej wg. wzoru (1.30) }

PROCEDURE RRALZD(VAR A    :MACZD;
                 VAR b,x  :WEKZD;
                     N    :BYTE;
                     EPS  :FLOAT;
                 VAR BLAD :BYTE);
{ Rozwiazywanie ukladu rownan liniowych zespolonych A*x=b;    }
{  A - macierz kwadratowa zespolona rzedu N                   }
{  b - zespolony wektor wyrazow wolnych                       }
{  x - zespolony wektor rozwiazania                           }
{  EPS - dokladnosc rozroznienia zerowej kolumny , detA=0     }
{  BLAD - nr bledu; 0 - brak bledu                            }

PROCEDURE SKALROWMACZD(VAR A,B :MACZD;
                           N,M :BYTE);
{ Skalowanie macierzy zespoloneych wg. wzoru (1.30)           }

PROCEDURE RRMAZD(VAR A,B,X :MACZD;
                     N,M   :BYTE;
                     EPS   :FLOAT;
                 VAR BLAD  :BYTE);
{ Rozwiazywanie rownania macierzowego A*X=B dla duzych macierzy        }
{  z zastosowaniem tablic dynamicznych typu MACZD                      }
{  A - macierz kwadratowa zespolona rzedu N                            }
{  B - macierz zespolona wyrazow wolnych o N-wierszach i M-kolumnach   }
{  X - macierz zespolona rozwiazania o N-wierszach i M-kolumnach       }
{  EPS - dokladnosc rozroznienia zerowego wiersza np EPS=1E-36         }
{  BLAD - nr bledu; 0 - brak bledu                                     }

PROCEDURE ODWMACZD(VAR A,B  :MACZD;
                       N    :BYTE;
                       EPS  :FLOAT;
                   VAR BLAD :BYTE);
{ Odwracanie dynamicznej macierzy zespolonej kwadratowej A rzedu N     }
{  B - macierz odwrotna wzgledem macierzy A  tj  A*B=A1                }
{  A1 - macierz jednostkowa                                            }
{  EPS - dokladnosc rozroznienia zerowego wiersza np EPS=1E-20         }
{  BLAD - nr bledu; 0 - brak bledu                                     }

PROCEDURE ODWMACZ1D(VAR A    :MACZD;
                        N    :BYTE;
                        EPS  :FLOAT;
                    VAR BLAD :BYTE);
{ Odwracanie dynamicznej macierzy zespolonej kwadratowej A rzedu N     }
{ i zapisanie jej w miejscu oryginalu.                                 }
{  EPS - dokladnosc rozroznienia zerowego wiersza np EPS=1E-20         }
{  BLAD - nr bledu; 0 - brak bledu                                     }

PROCEDURE DETZAD(VAR DETA :ZESPOL;
                 VAR A    :MACZD;
                     N    :BYTE;
                     EPS  :FLOAT);
{  Wyznacznik DETZAD macierzy kwadratowej zespolonej A rzedu N }
{  EPS - dokladnosc rozroznienia zerowej kolumny , DETA=0      }

FUNCTION NORMACZD(VAR A :MACZD;
                      N :BYTE):FLOAT;
{  Norma macierzy zespolonej kwadratowej dynamicznej A rzedu N }

FUNCTION WUMACZD(VAR A    :MACZD;
                     N    :BYTE;
                     EPS  :FLOAT;
                 VAR BLAD :BYTE):FLOAT;
{ Wspolczynnik uwarunkowania macierzy zespolonej dynamicznej A rzedu N }
{ EPS - dokladnosc rozroznienia zerowego wiersza np EPS=1E-36          }

FUNCTION MWWMZD(VAR A     :MACZD;
                    N     :BYTE;
                    EPS   :FLOAT;
                    maxit :WORD;
                VAR BLAD  :BYTE):FLOAT;
{ Wartosc wlasna macierzy zespoloej A o najwiekszym module          }
{ A - macierz zespolona dynamiczna kwadratowa rzed N                }
{ EPS - zadana dokladnosc bezwzgledna wyznaczania wartosci wlasnej  }
{ maxit - maksymalna liczba iteracji konczaca procedure             }
{ BLAD - nr bledu; 0 - brak bledu                                   }

FUNCTION MWWMZAD(VAR A        :MACZD;
                     N        :BYTE;
                     EPS,ALFA :FLOAT;
                     maxit    :WORD;
                 VAR BLAD     :BYTE):FLOAT;
{ Wartosc wlasna macierzy A1-ALFA*A o najwiekszym module           }
{ A - macierz zespolona dynamiczna kwadratowa rzed N               }
{ A1 - macierz jednostkowa                                         }
{ ALFA - parametr wiekszy od zera                                  }
{ EPS - zadana dokladnosc bezwzgledna wyznaczania wartosci wlasnej }
{ maxit - maksymalna liczba iteracji konczaca procedure            }
{ BLAD - nr bledu; 0 - brak bledu                                  }

PROCEDURE RRMAZIGSD(VAR A,B,X     :MACZD;
                        N,M       :BYTE;
                        EPS,OMEGA :FLOAT;
                        maxit     :WORD;
                    VAR BLAD      :BYTE);
{  Rozwiazywanie rownania macierzowego  A*X=B  metoda iteracji       }
{  Gaussa-Seidela OMEGA=1 oraz                                       }
{  nadrelaksacji  0<OMEGA<>1 wzor (1.68)(1.69)                       }
{  A - macierz zespolona kwadratowa dynamiczna rzedu N               }
{  B - macierz zespolona wyrazow wolnych o N-wierszach i M-kolumnach }
{  X - macierz zespolona rozwiazania o N-wierszach i M-kolumnach     }
{  EPS - dokladnosc bezwzgledna iteracji np EPS=1E-8                 }
{  OMEGA - parametr relaksacji                                       }
{  maxit - maksymalna liczba iteracji konczaca procedure             }
{  BLAD - nr bledu; 0 - brak bledu                                   }


IMPLEMENTATION

PROCEDURE NEWMACZD;
  VAR i   :INTEGER;
      PAO :LONGINT;
  BEGIN
    BLAD:=0;
    PAO:=(N+2)*SizeOf(WEKZD);
    IF PAO<MaxAvail
      THEN FOR i:=-1 TO N DO
             NEW(A[i])
      ELSE BLAD:=20
  END { NEWMACZD };

PROCEDURE DISMACZD;
  VAR i:INTEGER;
  BEGIN
    FOR i:=-1 TO N DO
      DISPOSE(A[i])
  END { DISMACZD };


PROCEDURE TRANMACZD;
 VAR i,j:BYTE;
 BEGIN
   FOR i:=1 TO M DO
     FOR j:=1 TO N DO
       At[j]^[i]:=A[i]^[j]
 END { TRANMACD };

PROCEDURE ADDMACZD;
  VAR i,j:BYTE;
  BEGIN
    FOR i:=1 TO M DO
      FOR j:=1 TO N DO
        ADD(C[i]^[j],A[i]^[j],B[i]^[j])
  END { ADDMACZD };

PROCEDURE SUBMACZD;
  VAR i,j:BYTE;
  BEGIN
    FOR i:=1 TO M DO
      FOR j:=1 TO N DO
        SUB(C[i]^[j],A[i]^[j],B[i]^[j])
  END { SUBMACD };

PROCEDURE MULMACZD;
  VAR i,j,k :BYTE;
      U,S   :ZESPOL;
      D0    :WEKZD;
  BEGIN
    FOR i:=1 TO M DO
    BEGIN
      FOR k:=1 TO P DO
      BEGIN
        S:=Z0;
        FOR j:=1 TO N DO
        BEGIN
          MUL(U,A[i]^[j],B[j]^[k]);
          ADD(S,S,U)
        END;
        D0[k]:=S
      END;
      D[i]^:=D0
    END
  END { MULMACZD };

PROCEDURE MULMACZZD;
 VAR i,j:BYTE;
 BEGIN
   FOR i:=1 TO M DO
     FOR j:=1 TO N DO
       MUL(A[i]^[j],B[i]^[j],z)
 END { MULMACZZD };

PROCEDURE MACZEROZD;
  VAR i:BYTE;
  BEGIN
    FOR i:=1 TO N DO
      FillChar(A0[I]^,SizeOf(A0[i]^),0)
  END { MACZEROZD };

PROCEDURE MACJEDENZD;
  VAR i:BYTE;
  BEGIN
    MACZEROZD(A1,N,N);
    FOR i:=1 TO N DO
      A1[i]^[i]:=Z1
  END { MACJEDENZD };

PROCEDURE SKALROWZD;
  VAR LN2,S,SX,S1 :FLOAT;
      i,j         :BYTE;
  BEGIN
    LN2:=LN(2);
    { Skalowanie ukladu rownan wg wzoru (1.30) }
    FOR i:=1 TO N DO
    BEGIN
      S:=0;
      FOR j:=1 TO N DO
      BEGIN
        SX:=MODUL(A[i]^[j]);
        S:=S+SX
      END;
      S1:=LN(S)/LN2+1;
      IF (S<0.5) OR (S>1.0) THEN
      BEGIN
        IF S1>=0
          THEN S:=EXP(-TRUNC(S1)*LN2)
          ELSE IF S1-TRUNC(S1)=0.0
                 THEN S:=EXP(-TRUNC(S1)*LN2)
                 ELSE S:=EXP(-TRUNC(S1-1)*LN2);
        FOR j:=1 TO N DO
          MULRZ(A[i]^[j],A[i]^[j],S);
        MULRZ(b[i],b[i],S)
      END
    END
  END; { SKALROWZD }


PROCEDURE RRALZD;
  VAR i,j,k                 :BYTE;
      T,MA                  :FLOAT;
      ZT,ZT1,ZT2,ZS,ZS1,ZS2 :ZESPOL;
  BEGIN
    BLAD:=0;
    { Konstrukcja ciagu macierzy A(i) wzory (1.20)(1.21)(1.23) oraz }
    { ciagu wektorow b(i) wzory (1.22)                              }
    FOR i:=1 TO N DO
    BEGIN
      { Wybor elementu glownego wg. wzoru (1.24) }
      T:=MODUL(A[i]^[i]);
      k:=i;
      FOR j:=i+1 TO N DO
      BEGIN
        MA:=MODUL(A[j]^[i]);
        IF MA>T THEN
        BEGIN
          T:=MA;
          k:=j
        END
      END;
      IF T<EPS THEN
      { Warunek przerwania poszukiwania elementow glownego wg. (1.27) }
      { nie istnieje rozwiazanie rownania , detA=0                    }
      BEGIN
        BLAD:=50;
        EXIT
      END;
      IF i=k
        THEN ZT:=A[i]^[i]
        ELSE BEGIN
               { Zamiana elementu k-tego z i-tym wektora b }
               ZT:=b[k]; b[k]:=b[i]; b[i]:=ZT;
               { Zamiana wiersza k-tego z i-tym macierzy A }
               FOR j:=N DOWNTO i DO
               BEGIN
                 ZT:=A[k]^[j]; A[k]^[j]:=A[i]^[j]; A[i]^[j]:=ZT
               END
             END;
      ODW(ZT,ZT);
      A[i]^[i]:=ZT;
      FOR j:=i+1 TO N DO
      BEGIN
        MULRZ(ZT1,ZT,-1);  MUL(ZS,A[j]^[i],ZT1); { wzor (1.23) }
        MUL(ZS1,b[i],ZS);  ADD(b[j],b[j],ZS1); { wzor (1.22) }
        FOR k:=i+1 TO N DO
        BEGIN
          MUL(ZS2,A[i]^[k],ZS); ADD(A[j]^[k],A[j]^[k],ZS2) { wzor (1.21) }
        END
      END
    END;
    { Rozwiazywanie ukladu trojkatnego metoda postepowania wstecz wzor (1.26) }
    FOR i:=N DOWNTO 1 DO
    BEGIN
      ZT:=b[i];
      FOR j:=i+1 TO N DO
      BEGIN
        MUL(ZS,A[i]^[j],X[j]);
        SUB(ZT,ZT,ZS)
      END;
      MUL(X[i],ZT,A[i]^[i])
    END
  END { RRALZD };

PROCEDURE SKALROWMACZD;
  VAR  i,j         :BYTE;
       S1,S,SX,LN2 :FLOAT;
  BEGIN
    LN2:=LN(2);
    FOR i:=1 TO N DO
    BEGIN
      S:=0;
      FOR j:=1 TO N DO
      BEGIN { Norma wiersza macierzy zespolonej S }
        SX:=MODUL(A[i]^[j]);
        S:=S+SX
      END;
      S1:=LN(S)/LN2+1; { wzor 1.30) }
      IF (S<0.5) OR (S>1.0) THEN
      BEGIN
        IF S1>=0
          THEN S:=EXP(-TRUNC(S1)*LN2)
          ELSE IF S1-TRUNC(S1)=0.0
                 THEN S:=EXP(-TRUNC(S1)*LN2)
                 ELSE S:=EXP(-TRUNC(S1-1)*LN2);
        FOR j:=1 TO N DO
          MULRZ(A[i]^[j],A[i]^[j],S);
        FOR j:=1 TO M DO
          MULRZ(B[j]^[i],B[j]^[i],S)
      END
    END
  END; { SKALROWMACZD }

PROCEDURE RRMAZD;
  VAR  i,j,k                 :BYTE;
       T,MA                  :FLOAT;
       ZT,ZT1,ZT2,ZS,ZS1,ZS2 :ZESPOL;
  BEGIN
    BLAD:=0;
    SKALROWMACZD(A,B,N,M);
    FOR i:=1 TO N DO
    BEGIN
      T:=MODUL(A[i]^[i]);
      k:=i;
      FOR j:=i+1 TO N DO
      BEGIN
        MA:=MODUL(A[j]^[i]);
        IF MA>T THEN
        BEGIN
          T:=MA;
          k:=j
        END
      END;
      IF T<EPS THEN
      BEGIN
        BLAD:=51;
        EXIT
      END;
      IF i=k
        THEN ZT:=A[i]^[i]
        ELSE BEGIN
               FOR j:=1 TO M DO
               BEGIN
                 ZT:=B[j]^[k]; B[j]^[k]:=B[j]^[i]; B[j]^[i]:=ZT
               END;
               FOR j:=N DOWNTO i DO
               BEGIN
                 ZT:=A[k]^[j]; A[k]^[j]:=A[i]^[j]; A[i]^[j]:=ZT
               END
             END;
      ODW(ZT,ZT); A[i]^[i]:=ZT;
      FOR j:=i+1 TO N DO
      BEGIN
        MULRZ(ZT1,ZT,-1); MUL(ZS,A[j]^[i],ZT1);
        FOR k:=1 TO M DO
        BEGIN
          MUL(ZS1,B[k]^[i],ZS);ADD(B[k]^[j],B[k]^[j],ZS1)
        END;
        FOR k:=i+1 TO N DO
        BEGIN
          MUL(ZS2,A[i]^[k],ZS);ADD(A[j]^[k],A[j]^[k],ZS2)
        END
      END
    END;
    FOR k:=1 TO M DO
      FOR i:=N DOWNTO 1 DO
      BEGIN
        ZT:=B[k]^[i];
        FOR j:=i+1 TO N DO
        BEGIN
          MUL(ZS,A[i]^[j],X[k]^[j]);
          SUB(ZT,ZT,ZS)
        END;
        MUL(X[k]^[i],ZT,A[i]^[i])
      END;
  END { RRMAZD };

PROCEDURE ODWMACZD;
  VAR  i,j :BYTE;
       A1  :MACZD;
  BEGIN
    NEWMACZD(A1,N,BLAD); { Utworzenie tablicy dynamicznej zespolonej }
    IF BLAD=0 THEN
    BEGIN
      { Generacja macierzy jednostkowej A1  }
      MACJEDENZD(A1,N);
       {                                                          -1 }
       { Rozwiazanie rownania macierzowego (1.36) A*B = A1 tj, B=A   }
      RRMAZD(A,A1,B,N,N,EPS,BLAD);
      DISMACZD(A1,N)  { Zwolnienie tablicy dynamicznej }
    END
  END { ODWMACZD };

PROCEDURE ODWMACZ1D;
VAR i,j,l,k   :BYTE;
    MmaxA,d   :FLOAT;
    maxA,e,f  :ZESPOL;
    M         :ARRAY[PMAXD] OF BYTE;
BEGIN
  BLAD:=0;
  FOR i:=1 TO N DO
  BEGIN
    { Czesciowy wybor elementu glownego wg wzoru (1.49)}
    MmaxA:=0;
    FOR j:=i TO N DO
    BEGIN
      d:=MODUL(A[j]^[i]);
      IF MmaxA<d THEN
      BEGIN
        MmaxA:=d;
        maxA:=A[j]^[i];
        k:=j
      END
    END;
    IF MmaxA<EPS THEN
    BEGIN
      BLAD:=52;
      EXIT
    END;
    { Zpisywanie wskaznikow wierszy wystepowania elementu
      ekstremalnego w i-tej iteracji w postaci wektora M[i] }
    M[i]:=k;
    A[k]^[i]:=Z1;
    FOR j:=1 TO N DO
    BEGIN
      { Przestawienie i-tego wiersz z k-tym }
      DIW(e,A[k]^[j],maxA);  A[k]^[j]:=A[i]^[j];  A[i]^[j]:=e
    END;
    { Generacja ciagu macierzy (1.42) wg wzoru rekurencyjnego (1.41) }
    FOR j:=1 TO N DO
      IF j<>i THEN
      BEGIN
        f:=A[j]^[i];
        A[j]^[i]:=Z0;
        FOR l:=1 TO N DO
        BEGIN
          MUL(e,f,A[i]^[l]);
          SUB(A[j]^[l],A[j]^[l],e)
        END
      END
  END;
  { Przestawianie kolumn macierzy zgodnie z wektorem wskaznikow M[i] (1.46) }
  FOR i:=N DOWNTO 1 DO
  BEGIN
    k:=M[i];
    IF k<>i THEN
      FOR j:=1 TO N DO
      BEGIN
        e:=A[j]^[i];
        A[j]^[i]:=A[j]^[k];
        A[j]^[k]:=e
      END
  END
END; { ODWMACZ1D }


PROCEDURE DETZAD;
  VAR  M,i,j,k                 :BYTE;
       S1,T,SX,LN2,MA          :FLOAT;
       S,ZT,ZT1,ZT2,ZS,ZS1,ZS2 :ZESPOL;
  BEGIN
    M:=0;
    { Konstrukcja ciagu macierzy A(i) wzory (1.20)(1.21)(1.23) oraz }
    FOR i:=1 TO N DO
    BEGIN
      { Wybor elementu glownego wg. wzoru (1.24) }
      T:=MODUL(A[i]^[i]); k:=i;
      FOR j:=i+1 TO N DO
      BEGIN
        MA:=MODUL(A[j]^[i]);
        IF MA>T THEN
        BEGIN
          { Zliczanie ilosci M przestawien wierszy }
          T:=MA ; k:=j; M:=M+1
        END
      END;
      IF T<EPS THEN
        { Warunek przerwania poszukiwania elementow glownego wg. (1.27) }
        { nie istnieje rozwiazanie rownania , DETA=0                    }
      BEGIN
        DETA:=Z0; { zero zespolone Z0 }
        EXIT
      END;
      IF i=k
        THEN ZT:=A[i]^[i]
        ELSE { Zamiana wiersza k-tego z i-tym macierzy A }
             FOR j:=N DOWNTO i DO
             BEGIN
               ZT:=A[k]^[j]; A[k]^[j]:=A[i]^[j]; A[i]^[j]:=ZT
             END;
      ODW(ZT,ZT);
      FOR j:=i+1 TO N DO
      BEGIN
        MULRZ(ZT1,ZT,-1);  MUL(ZS,A[j]^[i],ZT1); { wzor (1.23) }
        FOR k:=i+1 TO N DO
        BEGIN
          MUL(ZS2,A[i]^[k],ZS); ADD(A[j]^[k],A[j]^[k],ZS2) { wzor (1.21) }
        END
      END
    END;
    S:=Z1;
    { Obliczanie wyznacznika }
    FOR i:=1 TO N DO
      MUL(S,S,A[i]^[i]);
    IF FRAC(M/2)=0.0
      THEN DETA:=S
      ELSE MULRZ(DETA,S,-1)
  END { DETZA };

FUNCTION NORMACZD;
  VAR i,j  :BYTE;
      RR,S :FLOAT;
  BEGIN
    RR:=0;
    FOR j:=1 TO N DO
    BEGIN
      S:=0;
      FOR i:=1 TO N DO
        S:=S+MODUL(A[i]^[j]);
      IF RR<S THEN
        RR:=S
    END;
    NORMACZD:=RR
  END { NORMACZD };

FUNCTION WUMACZD;
  VAR KM1,KM2 :FLOAT;
  BEGIN
    KM1:=NORMACZD(A,N); { Norma macierzy dynamicznej }
    ODWMACZ1D(A,N,EPS,BLAD); { Odwracanie macierzy A }
    IF BLAD<>0
      THEN WUMACZD:=1/EPS
      ELSE BEGIN
             KM2:=NORMACZD(A,N); { Norma macierzy dynamicznej B }
             WUMACZD:=KM1*KM2;
           END
  END { WUMAZCZD };

FUNCTION MWWMZD;
  VAR i,j              :BYTE;
      k                :WORD;
      MS,P,R,T,WW1,WW2 :FLOAT;
      S,S1             :ZESPOL;
      W,U              :WEKZD;
  BEGIN
    BLAD:=0;
    FOR i:=1 TO N DO
    BEGIN
      P:=0.02*i;
      MULRZ(W[i],Z1,P)
    END;   { wektor poczatkowy (1.56) }
    P:=1.0; WW2:=100.0; k:=0;
    REPEAT
      R:=0.0; k:=k+1;
      { wzor 1.50) }
      FOR i:=1 TO N DO
      BEGIN
        S:=Z0;
        FOR j:=1 TO N DO
        BEGIN
          MUL(S1,A[i]^[j],W[j]);
          ADD(S,S,S1)
        END;
        U[i]:=S;  MS:=MODUL(S);
        IF MS>R THEN  { wyznaczanie normy wektora wzor (1.57) }
          R:=MS
      END;
      WW1:=R/P;  { przyblizanie granicy (1.55) }
      P:=R; W:=U; T:=ABS(WW1-WW2); WW2:=WW1
    UNTIL (T<EPS) OR (k>maxit);
    IF k>maxit
      THEN BLAD:=53
      ELSE MWWMZD:=WW1
  END { MWWMZD };

FUNCTION MWWMZAD;
  VAR i,j              :BYTE;
      k                :WORD;
      P,R,MS,T,WW1,WW2 :FLOAT;
      S,S1             :ZESPOL;
      W,U              :WEKZD;
  BEGIN
    BLAD:=0;
    FOR i:=1 TO N DO
    BEGIN
      P:=0.02*i;
      MULRZ(W[i],Z1,P)
    END;   { wektor poczatkowy (1.56) }
    P:=1.0; WW2:=100.0; k:=0;
    REPEAT
      R:=0.0; k:=k+1;
      { wzor 1.58) }
      FOR i:=1 TO N DO
      BEGIN
        S:=Z0;
        FOR j:=1 TO N DO
        BEGIN
          MUL(S1,A[i]^[j],W[j]);
          ADD(S,S,S1)
        END;
        MULRZ(S,S,ALFA); SUB(U[i],W[i],S); MS:=MODUL(U[i]);
        IF MS>R THEN  { wyznaczanie normy wektora wzor (1.57) }
          R:=MS
      END;
      WW1:=R/P;  { przyblizanie granicy (1.55) }
      P:=R; W:=U; T:=ABS(WW1-WW2); WW2:=WW1;
    UNTIL (T<EPS) OR (k>maxit);
    IF k>maxit
      THEN BLAD:=54
      ELSE MWWMZAD:=WW1
  END { MWWMZAD };

PROCEDURE RRMAZIGSD;
  VAR i,j,l,k     :BYTE;
      p           :WORD;
     R,R1,MS,MA,T :FLOAT;
     S,S1,ZT      :ZESPOL;
     y            :WEKZD;
  BEGIN
    BLAD:=0;
    SKALROWMACZD(A,B,N,M); { Skalowanie macierzy wg. wzoru (1.30) }
    { Poszukiwanie maksymalnych co do modulu elementow glownych }
    FOR i:=1 TO N DO
    BEGIN
      T:=MODUL(A[i]^[i]); k:=i;
      FOR j:=i+1 TO N DO
      BEGIN
        MA:=MODUL(A[j]^[i]);
        IF MA>T THEN
        BEGIN
          T:=MA;
          k:=j
        END
      END;
      IF i<>k THEN
      BEGIN
        FOR j:=1 TO M DO
        BEGIN
          ZT:=B[j]^[k]; B[j]^[k]:=B[j]^[i]; B[j]^[i]:=ZT
        END;
        FOR j:=1 TO N DO
        BEGIN
          ZT:=A[k]^[j]; A[k]^[j]:=A[i]^[j]; A[i]^[j]:=ZT
        END
      END
    END;
    R:=MWWMZAD(A,N,1E-4,OMEGA,maxit,BLAD);
    p:=0;
    { Najwieksza co do modulu wartosc wlasna macierzy A1-OMEGA*A }
    IF R>=1 THEN
    BEGIN
      BLAD:=55;
      EXIT
    END;
    REPEAT
      R1:=0; p:=p+1;
      FOR l:=1 TO M DO
      BEGIN
        y:=X[l]^ ; R:=0.0;
        FOR i:=1 TO N DO
        BEGIN
          S:=B[l]^[i];
          FOR j:=1 TO i-1 DO
          BEGIN
            MUL(S1,A[i]^[j],X[l]^[j]);
            SUB(S,S,S1)
          END;
          FOR j:=i TO N DO
          BEGIN
            MUL(S1,A[i]^[j],y[j]);
            SUB(S,S,S1)
          END;
          MULRZ(S1,S,OMEGA);
          ADD(X[l]^[i],y[i],S1);
          MS:=MODUL(S);
          IF MS>R THEN
            R:=MS
        END;
        IF R>R1 THEN
          R1:=R
      END
    UNTIL (R1<EPS) OR (p>maxit);
    IF p>maxit THEN
      BLAD:=56
  END { RRMAZIGSZD };

END.

