%% Przyklad 8.2.4-1  
% Badanie zgodnosci rozwiazania analitycznego i rozwiazan numerycznych uzyskanych
% z uzyciem solverw ode45, ode23 i ode113.
options= odeset('RelTol',1e-5);
[t,y]= ode45(@eqdif1,[0 16],[-1 -2],options);
[t23,y23]= ode23(@eqdif1,[0 16],[-1 -2],options);
[t13,y13]= ode113(@eqdif1,[0 16],[-1 -2],options);
ya= -2.*sin(t)-cos(2.*t);
plot(t,ya,'r',t,y(:,1),'--',t23,y23(:,1),'m-.',t13,y13(:,1),'g:')
s='Porwnanie rozwiazania analitycznego z obliczeniami numerycznymi'
title(s)
legend('ya','ode45','ode23','ode113') % legenda do linii wykresu
text(3.4,-1.7,'ya = -2sin(t) - cos(2t)')

function dy =eqdif1(t,y)
dy = [y(2); 4.*sin(t) + 5.*cos(2.*t)+ y(1)];
end