var cv = document.getElementById('canvas');
var ctx = cv.getContext('2d');
var w = cv.width;
var h = cv.height;
var x0 = w / 2.0;
var y0 = h / 2.0;
var distx = x0 / 13;
var disty = y0 / 13;
var col = "black";
var col1 = "red";
var lw = 0.5;
var bw = 12;
var bh = 10;
var cl = true;
var dist = 30;
var m = 30;
var corr = 150;

function drawAxes(axes) {
	ctx.save();
	ctx.beginPath();
	ctx.fillStyle = "black";
	ctx.textBaseline = "middle";
	ctx.textAlign = "center";
	if (axes === "complex" || axes === "cartesian") {
		ctx.fillText("X", w - distx / 2, y0);
		ctx.fillText("-X", 0 + distx / 2, y0);
		ctx.fillText("Y", x0, 0 + disty / 2, y0);
		ctx.fillText("-Y", x0, h - disty / 2);
		for (var i = 0; i < 12; i++) {
			ctx.fillText(i.toString(), x0 + i * m, y0 + 12);
		}
		for (var k = 11; k > 0; k--) {
			ctx.fillText((-k).toString(), 99 + (10 - k) * m, y0 + 12);
		}
		if (axes === "complex") {
			ctx.fillStyle = "red";
			col1 = "red";
		}
		if (axes === "cartesian") {
			ctx.fillStyle = "black";
			col1 = "black";
		}
		for (var j = 0; j < 12; j++) {
			ctx.fillText(j.toString(), x0 - 12, y0 - j * m);
		}
		for (var n = 11; n > 0; n--) {
			ctx.fillText((-n).toString(), x0 - 12, y0 + n * m);
		}

		drawArrow(x0, y0, x0 - distx, lw, 0, bw, bh, cl, col);
		drawArrow(x0, y0, x0 - distx, lw, 180, bw, bh, cl, col);
		drawArrow(x0, y0, y0 - disty, lw, 90, bw, bh, cl, col1);
		drawArrow(x0, y0, y0 - disty, lw, 270, bw, bh, cl, col1);
	}
	if (axes === "js") {

		ctx.fillText("X", w - 12, 15);
		ctx.fillText("Y", 15, h - 12);
		for (var i = 0; i < 24; i++) {
			ctx.fillText(i.toString(), 15 + i * m, 8);
		}

		for (var j = 23; j > 0; j--) {
			ctx.fillText(j.toString(), 7, 15 + j * m);
		}
		drawArrow(15, 15, w - 40, lw, 0, bw, bh, cl, col);
		drawArrow(15, 15, w - 40, lw, 270, bw, bh, cl, col);

	}
	ctx.restore();

};

function drawAxesG(axes, gameMatrix) {
	var min = gameMatrix.gameMin();
	var max = gameMatrix.gameMax();
	var diff = Math.abs(min) + Math.abs(max);
	diff = Math.ceil(diff / 23.0);
	var y5 = 400;
	ctx.save();
	ctx.beginPath();
	ctx.fillStyle = "black";
	ctx.textBaseline = "middle";
	ctx.textAlign = "center";
	if (axes === "games") {
		// left
		for (var n = 11; n > -12; n--) {
			ctx.fillText((-n * diff).toString(), x0 - 12 - corr, y5 + n * m);
		}
		drawArrow(x0 - corr, y0, y0 - disty, lw, 90, bw, bh, cl, col);
		drawArrow(x0 - corr, y0, y0 - disty, lw, 270, bw, bh, cl, col);
		// right
		for (var n = 11; n > -12; n--) {
			ctx.fillText((-n * diff).toString(), x0 + 12 + corr, y5 + n * m);
		}
		drawArrow(x0 + corr, y0, y0 - disty, lw, 90, bw, bh, cl, col);
		drawArrow(x0 + corr, y0, y0 - disty, lw, 270, bw, bh, cl, col);
	}
	if (gameMatrix.rows === 2) {
		ctx.beginPath();
		for (var i = 0; i < gameMatrix.cols; i++) {
			ctx.moveTo(x0 - corr, y5 - ((gameMatrix.array[0][i]) / diff) * m);
			ctx.lineTo(x0 + corr, y5 - ((gameMatrix.array[1][i]) / diff) * m);
		}
		ctx.stroke();
	} else if (gameMatrix.cols === 2) {
		ctx.beginPath();
		for (var i = 0; i < gameMatrix.rows; i++) {
			ctx.moveTo(x0 - corr, y5 - ((gameMatrix.array[i][0]) / diff) * m);
			ctx.lineTo(x0 + corr, y5 - ((gameMatrix.array[i][1]) / diff) * m);
		}
		ctx.stroke();
	}
	ctx.restore();
};
