var cv = document.getElementById('canvas');
var ctx = cv.getContext('2d');
/**
 * Tworzy obiekt typu Arrow
 * 
 * @param endX
 *            float - współrzędna x tylnego końca strzałki
 * @param endY
 *            float - współrzędna y tylnego końca strzałki
 * @param arrowLength
 *            float - długość strzałki
 * @param arrowWidth
 *            float - grubość strzałki
 * @param arrowAngle
 *            float - kat pod ktorym jest skierowana strzalka katy podawane sa w
 *            stopniach, kat zerowy to polozenie godziny 3.00, katy wzrastaja w
 *            kierunku przeciwnym do wskazowek zegara
 * @param brudLength
 *            float - długość grota mierzona wzdłuż osi strzałki
 * @param brudAngle
 *            float - kąt między osią strzałki a brzegiem grota
 * @param close
 *            boolean -
 *            <ul>
 *            <li>true - grot bez wcięcia *
 *            <li>false - grot z wcięciem
 *            </ul>
 * @param fillStyle - styl wypełnienia
 */
function drawArrow(endX, endY, arrowLength, arrowWidth, arrowAngle, brudLength,
		brudAngle, close, fillStyle) {
	this.endX = endX;
	this.endY = endY;
	this.arrowLength = arrowLength;
	this.arrowAngle = arrowAngle;
	this.brudLength = brudLength;
	this.brudAngle = brudAngle;
	this.close = close;
	this.fillStyle = fillStyle;
	var cosa = Math.cos(degToRad(arrowAngle));
	var sina = Math.sin(degToRad(arrowAngle));
	var half = arrowWidth / 2.0;
	var cosah = cosa * half;
	var sinah = sina * half;
	var startX = endX + arrowLength * Math.cos(degToRad(-arrowAngle));
	var startY = endY + arrowLength * Math.sin(degToRad(-arrowAngle));
	var middleX = endX + (arrowLength - brudLength)
			* Math.cos(degToRad(-arrowAngle));// x7
	var middleY = endY + (arrowLength - brudLength)
			* Math.sin(degToRad(-arrowAngle));// y7
	var cosb = Math.cos(degToRad(brudAngle));
	var sinb = Math.sin(degToRad(brudAngle));
	var w2 = half * cosb / sinb;
	var mmiddleX = endX + (arrowLength - w2) * Math.cos(degToRad(-arrowAngle));//
	var mmiddleY = endY + (arrowLength - w2) * Math.sin(degToRad(-arrowAngle));//
	var w3 = brudLength - w2;
	var w4 = w3 * sinb / cosb;
	var w5 = w4 + half;
	// -
	var x1 = endX - sinah;
	var y1 = endY - cosah;
	var x2 = endX + sinah;
	var y2 = endY + cosah;
	var x5 = middleX + sinah;
	var y5 = middleY + cosah;
	var x6 = middleX - sinah;
	var y6 = middleY - cosah;
	var x8 = mmiddleX + sinah;
	var y8 = mmiddleY + cosah;
	var x9 = mmiddleX - sinah;
	var y9 = mmiddleY - cosah;
	var x10 = middleX + sina * w5;
	var y10 = middleY + cosa * w5;
	var x11 = middleX - sina * w5;
	var y11 = middleY - cosa * w5;
	ctx.save();
	ctx.beginPath();
	ctx.fillStyle = this.fillStyle;
	ctx.strokeStyle = this.fillStyle;
	ctx.lineWidth = arrowWidth;
	if (this.close) {
		ctx.moveTo(x1, y1);
		ctx.lineTo(x2, y2);
		ctx.lineTo(x5, y5);
		ctx.lineTo(x10, y10);
		ctx.lineTo(x8, y8);
		ctx.lineTo(startX, startY);
		ctx.lineTo(x9, y9);
		ctx.lineTo(x11, y11);
		ctx.lineTo(x6, y6);
		ctx.closePath();
		ctx.fill();
		ctx.stroke();
	} else {
		ctx.moveTo(x1, y1);
		ctx.lineTo(x2, y2);
		ctx.lineTo(x8, y8);
		ctx.lineTo(startX, startY);
		ctx.lineTo(x9, y9);
		ctx.lineTo(x1, y1);
		ctx.fill();
		ctx.moveTo(x11, y11);
		ctx.lineTo(x9, y9);
		ctx.moveTo(x10, y10);
		ctx.lineTo(x8, y8);
		ctx.stroke();
	}
	ctx.restore();
};
/*
 * funkcja zamienia stopnie na radiany
 */
// k¹t deg podajemy w stopniach
var degToRad = function(deg) {
	return Math.PI * deg / 180.0;
};

/*
 * funkcja zamienia radiany na stopnie k¹t rad podajemy w radianach
 */
var radToDeg = function(rad) {
	return rad * 180.0 / Math.PI;
};
var arrowLength = function(x1, y1, x2, y2) {
	var distance = 0.0;
	var x3 = x1 - x2;
	var y3 = y1 - y2;
	distance = Math.sqrt(x3 * x3 + y3 * y3);
	return distance;
};
var atan2Deg = function(yy, xx) {
	return Math.atan2(yy, xx) * 180.0 / Math.PI;
};
var arrowAngle = function(x1, y1, x2, y2) {
	var x3 = x1 - x2;
	var y3 = y1 - y2;
	return atan2Deg(x3, y3);
};
