function Rzutowanie(sx, sy, sw, sh, rx, ry, rw, rh) {
	this.sx = sx;
	this.sy = sy;
	this.sw = sw;
	this.sh = sh;
	this.rx = rx;
	this.ry = ry;
	this.rw = rw;
	this.rh = rh;
};
Rzutowanie.prototype.getSX = function(realx) {
	if ((realx < this.rx) || (realx > (this.rx + this.rw))) {
		return new Error("Argument poza podanym zakresem");
	}
	return this.sx + ((realx - this.rx) / this.rw) * this.sw;
};
Rzutowanie.prototype.getSY = function(realy) {
	if ((realy < this.ry) || (realy > (this.ry + this.rh))) {
		return new Error("Argument poza podanym zakresem");
	}
	return this.sy + ((realy - this.ry) / this.rh) * this.sh;
};
Rzutowanie.prototype.getRX = function(screenx) {
	if ((screenx < this.sx) || (screenx > (this.sx + this.sw))) {
		return new Error("Argument poza podanym zakresem");
	}
	return this.rx + ((screenx - this.sx) / this.sw) * this.rw;
};
Rzutowanie.prototype.getRY = function(screeny) {
	if ((screeny < this.sy) || (screeny > (this.sy + this.sh))) {
		return new Error("Argument poza podanym zakresem");
	}
	return this.ry + ((screeny - this.sy) / this.sh) * this.rh;
};
Rzutowanie.prototype.getRwSw = function() {
	return this.rw / this.sw;
};
Rzutowanie.prototype.getSwRw = function() {
	return this.sw / this.rw;
};
Rzutowanie.prototype.getRhSh = function() {
	return this.rh / this.sh;
};

Rzutowanie.prototype.getShRh = function() {
	return this.sh / this.rh;
};