// logarytm naturalny z b
var ln = function(b) {
	return Math.log(b);
};
// logarytm dziesiętny z b
var lg = function(b) {
	return Math.LOG10E * Math.log(b);
};
/**
 * oblicza logarytm o dowolnej podstawie z podanej liczby także o podstawie 10
 * albo e
 * @param b - liczba, której logarytm trzeba obliczyć
 * @param a - podstawa logarytmu
 * @return zwraca obliczony logarytm
 */
var log = function(b, a) {
	return Math.log(b) / Math.log(a);
};
/**
 * H albo hartley określa liczbę bitów na dit i służy do przeliczania między
 * tymi jednostkami
 */
var H = function() {
	return 1.0 / lg(2);
};

/**
 * @param liczbaElementow - liczba elementów układu
 * @param liczbaStanowElementu - liczba odróżnialnych stanów elementu
 * @return - liczbę stanów badanego układu
 */
var liczbaStanowUkladu = function(liczbaElementow, liczbaStanowElementu) {
	return Math.pow(liczbaStanowElementu, liczbaElementow);
};

/**
 * Oblicza różnorodność zbioru rozróżnialnych stanów
 * @param liczbaStanow - liczba możliwych sytanów
 * @return - zwraca różnorodność zbioru wyrażoną w postaci liczby bitów
 */
var roznorodnosc2 = function(liczbaStanow) {
	return log(liczbaStanow, 2);
};

/**
 * Oblicza różnorodność zbioru rozróżnialnych stanów
 * @param liczbaStanow - liczba możliwych sytanów
 * @return - zwraca różnorodność zbioru wyrażoną w postaci liczby ditów
 */
var roznorodnosc10 = function(liczbaStanow) {
	return lg(liczbaStanow);
};

/**
 * Entropia w ditach
 * @param tabl - tablica prawdopodobieństw stanów
 * @return - entropię w ditach
 */
var entropiaD = function(tabl) {
	var sum = 0;
	for ( var i = 0; i < tabl.length; i++) {
		if (tabl[i] !== 0) {
			sum += tabl[i] * lg(tabl[i]);
		}
	}
	return (-1.0) * sum;
};

/**
 * Entropia w bitach
 * @param tabl - tablica prawdopodobieństw stanów
 * @return - entropię w bitach
 */
var entropiaB = function(tabl) {
	var sum = 0;
	for ( var i = 0; i < tabl.length; i++) {
		if (tabl[i] !== 0) {
			sum += tabl[i] * log(tabl[i], 2);
		}
	}
	return (-1.0) * sum;
};

/**
 * Ilość informacji przekazywanej przez system
 * @param tabl - tablica prawdopodobieństw
 * @return - ilość informacji w bitach/stan
 */
var srednia_informacja = function(tabl) {
	var sum = 0;
	for ( var i = 0; i < tabl.length; i++) {
		if (tabl[i] !== 0) {
			sum += tabl[i] * log(1.0 / tabl[i], 2);
		}
	}
	return sum;
};

/**
 * Ilość informacji przekazywanej przez system
 * @param tabl - tablica [][] prawdopodobieństw
 * @param n - liczebnosc populacji
 * @return - średnia ilość informacji w bitach/stan
 */
var srednia_informacja2 = function(tabl, n) {
	var r = tabl.length;// liczba rzędów
	var temp = new Array(r);
	var entropia = new Array(r);
	var czestosc = new Array(r);
	for ( var i = 0; i < r; i++) {
		czestosc[i] = tabl[i][0] + tabl[i][1] + tabl[i][2];
	}
	for ( var k = 0; k < czestosc.length; k++) {
		czestosc[k] /= parseInt(n);                
	}
	for ( var l = 0; l < r; l++) {
		for ( var m = 0; m < r; m++) {
			temp[m] = tabl[m][l];
		}
		entropia[l] = entropiaB(temp);
	}
	var sum = 0;
	var sum2 = 0;
	for ( var o = 0; o < entropia.length; o++) {
		sum += entropia[o] * czestosc[o];
		sum2 += czestosc[o];
	}
	return sum / sum2;
};
