package math.stat;

import javax.swing.*;
import java.awt.*;

public class Stat07 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 600;
    public static final int fh = 600;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            double[] data = {56.0, 28.3, 67.2, 36.8, 89.7, 32.7, 12.8, 13.9};
            String[] labels = {"polski", "angielski", "hiszpański",
                    " włoski", "rosyjski", "japoński", "keczua", "tajski"};
            new Stat07(new ApplePie(400, data, labels));
        });
    }

    public Stat07(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}
