package math.polynomials;

import java.util.Comparator;

public class MinFirstComp implements Comparator<Jdm> {
    @Override
    public int compare(Jdm o1, Jdm o2) {
        if (!o1.getLetter().equals(o2.getLetter())) {
            return o2.getLetter().compareTo(o1.getLetter());
        }
        int a = o2.getExp();
        int b = o1.getExp();
        if (a > b) {
            return -1;
        }
        if (a < b) {
            return 1;
        }
        if (a == b) {
            if (o1.getCoeff() < o2.getCoeff()) {
                return -1;
            }
            if (o1.getCoeff() > o2.getCoeff()) {
                return 1;
            }
        }
        return 0;
    }
}
