package math.polynomials;

import java.util.Comparator;

public class MaxFirstComp implements Comparator<Jdm> {
    @Override
    public int compare(Jdm o1, Jdm o2) {
        if (!o1.getLetter().equals(o2.getLetter())) {
            return o1.getLetter().compareTo(o2.getLetter());
        }
        int a = o1.getExp();
        int b = o2.getExp();
        if (a > b) {
            return -1;
        }
        if (a < b) {
            return 1;
        }
        if (a == b) {
            if (o1.getCoeff() < o2.getCoeff()) {
                return -1;
            }
            if (o1.getCoeff() > o2.getCoeff()) {
                return 1;
            }
        }
        return 0;
    }
}
