package math.matrix;

import javax.swing.table.AbstractTableModel;
import java.text.DecimalFormat;

public class MatrixTableModel extends AbstractTableModel {
    private static final long serialVersionUID = -443758665172380994L;
    private final Object[][] array;

    public MatrixTableModel(double[][] tabl) {
        array = new Object[tabl.length][tabl[0].length];
        for (int i = 0; i < tabl.length; i++) {
            for (int j = 0; j < tabl[0].length; j++) {
                array[i][j] = tabl[i][j];
            }
        }
    }

    @Override
    public int getRowCount() {
        return array.length;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public int getColumnCount() {
        return array[0].length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return array[row][col];
    }

    @Override
    public void setValueAt(Object value, int r, int c) {
        DecimalFormat form = new DecimalFormat("##0.00");
        Double val = Double.valueOf((String) value);
        array[r][c] = form.format(val);
        this.fireTableCellUpdated(r, c);
    }
}
