package math.linear;

import math.axes.CartesianAxPanel;

import javax.swing.*;
import java.awt.*;

public class Wektor14 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Wektor14(new VectorPanel14()));
    }

    public Wektor14(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        //	setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class VectorPanel14 extends CartesianAxPanel {
    private static final long serialVersionUID = 8115404932220947612L;

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        Vector2 vector1 = new Vector2(4.5, 3.5);
        LinearUtil.drawVector(vector1, g2, Color.BLUE);
        Vector2 vector2 = null;
        vector2 = vector1.normal("left");
        LinearUtil.drawVector(vector2, g2, Color.RED);
        g2.drawString(vector2.toString(), 410, 280);
        g2.drawString("isNormal(vector2)?: " + vector2.isNormalTo(vector1),
                420, 380);
    }
}
