package math.complex;

import math.shapes.Arrow;

import java.awt.*;

public class ComplexPanel extends ComplexAxPanel {
    private static final long serialVersionUID = -3904631072692648027L;
    private static final float x0 = w / 2f;
    private static final float y0 = (h - 30) / 2f;
    private final Complex complex;
    private Arrow arrow;
    private final Complex[] tabComplex;
    private final Arrow[] tabArrow;
    private final boolean red;
    private final CType type;

    public ComplexPanel(Complex complex, CType type) {
        super();
        this.complex = complex;
        arrow = new Arrow(x0, y0, (float) (complex.mod() * m), 1f,
                (float) complex.arg(), 15f, 10f, true);
        tabArrow = null;
        red = false;
        tabComplex = null;
        this.type = type;
    }

    public ComplexPanel(Complex[] tabComplex, boolean red, CType type) {
        super();
        tabArrow = new Arrow[tabComplex.length];
        double x1 = 0;
        double y1 = 0;
        for (int i = 0; i < tabArrow.length; i++) {
            x1 = tabComplex[i].getR();
            y1 = tabComplex[i].getFi();
            tabArrow[i] = new Arrow(x0, y0, (float) (x1 * m), 1f, (float) y1,
                    15f, 10f, true);
        }
        this.red = red;
        this.complex = null;
        this.tabComplex = tabComplex;
        this.type = type;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.BLACK);
        if (arrow != null) {
            g2.fill(arrow);
        }
        //------------------------- draw roots or powers
        if (tabArrow != null) {
            for (int i = 0; i < tabArrow.length; i++) {
                if (i == 0 && red) {
                    g2.setColor(Color.RED);
                    g2.fill(tabArrow[i]);
                } else {
                    g2.setColor(Color.BLACK);
                    g2.fill(tabArrow[i]);
                }
            }
        }
        //-------------------------- draw equation
        g2.setFont(font);
        g2.setColor(Color.BLUE);
        if (complex != null) {
            if (type == CType.Normal) {
                g2.drawString(complex.toString(CType.Normal), 10, 50);
            } else if (type == CType.Trigo) {
                g2.drawString(complex.toString(CType.Trigo), 10, 50);
            }
        }
        if (tabComplex != null) {
            if (type == CType.Normal) {
                for (int i = 0; i < tabComplex.length; i++) {
                    g2.drawString(tabComplex[i].toString(CType.Normal), 10,
                            20 * (i + 1));
                }
            } else if (type == CType.Trigo) {
                for (int i = 0; i < tabComplex.length; i++) {
                    g2.drawString(tabComplex[i].toString(CType.Trigo), 10,
                            20 * (i + 1));
                }
            }
        }
    }
}
