package math.axes;

import math.games.GameMatrix;
import math.shapes.Arrow;

import javax.swing.*;
import java.awt.*;

public class GameAxPanel extends JPanel {
    private static final long serialVersionUID = 5218506428064759030L;
    private static final Stroke bStroke = new BasicStroke(1f,
            BasicStroke.CAP_BUTT, BasicStroke.JOIN_BEVEL);
    private static final Font axFont = new Font("Dialog", Font.PLAIN, 8);
    private final static float m = 30f;
    private static final int w = 800;
    private static final int h = 800;
    private final GameMatrix gameMatrix;
    private final int diff;

    public GameAxPanel(GameMatrix gameMatrix) {
        this.gameMatrix = gameMatrix;
        double min = gameMatrix.gameMin();
        double max = gameMatrix.gameMax();
        this.diff = (int) Math.ceil((Math.abs(min) + Math.abs(max)) / 23);
        setPreferredSize(new Dimension(w, h));
        setSize(w, h);
        setBackground(Color.WHITE);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawRect(0, 0, w - 1, h - 1);
        g2.setStroke(bStroke);
        g2.setColor(Color.BLACK);
        g2.setFont(axFont);
        // left
        int x0 = w / 2;
        int corr = 150;
        int y5 = 400;
        for (int n = 11; n > -12; n--) {
            g2.drawString("" + -n * diff, x0 - 12 - corr - 4, y5 + n * m + 3);
        }
        boolean cl = true;
        float bh = 10.0f;
        float bw = 12.0f;
        float lw = 0.5f;
        int disty = 30;
        int y0 = h / 2;
        Arrow arrow1 = new Arrow(x0 - corr, y0, y0 - disty, lw, 90, bw, bh, cl);
        g2.fill(arrow1);
        Arrow arrow2 = new Arrow(x0 - corr, y0, y0 - disty, lw, 270, bw, bh, cl);
        g2.fill(arrow2);
        // right
        for (int n = 11; n > -12; n--) {
            g2.drawString("" + -n * diff, x0 + 12 + corr - 4, y5 + n * m + 3);
        }
        Arrow arrow3 = new Arrow(x0 + corr, y0, y0 - disty, lw, 90, bw, bh, cl);
        g2.fill(arrow3);
        Arrow arrow4 = new Arrow(x0 + corr, y0, y0 - disty, lw, 270, bw, bh, cl);
        g2.fill(arrow4);
        if (gameMatrix.getRows() == 2) {
            for (int i = 0; i < gameMatrix.getCols(); i++) {
                g2.drawLine(x0 - corr,
                        (int) (y5 - ((gameMatrix.getArray()[0][i]) / diff) * m),
                        x0 + corr,
                        (int) (y5 - ((gameMatrix.getArray()[1][i]) / diff) * m));
            }
        } else if (gameMatrix.getCols() == 2) {
            for (int i = 0; i < gameMatrix.getRows(); i++) {
                g2.drawLine(x0 - corr,
                        (int) (y5 - ((gameMatrix.getArray()[i][0]) / diff) * m),
                        x0 + corr,
                        (int) (y5 - ((gameMatrix.getArray()[i][1]) / diff) * m));
            }
        }
    }
}