package math.line;

import math.axes.CartesianAxPanel;
import math.shapes.Line;
import math.utils.Tuple2d;

import javax.swing.*;
import java.awt.*;

public class Line15 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Line15(new LinePanel15()));
    }

    public Line15(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        //	setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class LinePanel15 extends CartesianAxPanel {
    private static final long serialVersionUID = 8115404932220947612L;

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        Line line = new Line(-3f, 8f, 4f, -4);
        g2.drawString("line: " + line.toString(), 460, 280);
        g2.drawString("slope: " + line.slope(), 460, 300);
        LineUtil.drawLine(line, g2, Color.BLACK, 10);
        Tuple2d[] points = LineUtil.points(line, 10);
        for (Tuple2d point : points) {
            System.out.println(point.toString());
        }
    }
}
