package math.binary.binclock;

import javax.swing.*;
import java.awt.*;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Timer;
import java.util.TimerTask;

public class BCDClock extends JPanel {
    private static final long serialVersionUID = 5574563625746599928L;
    //BCD 8421
    public static final String[] kod_bcd = {"0000", "0001", "0010", "0011",
            "0100", "0101", "0110", "0111", "1000", "1001"};
    private GregorianCalendar gc = null;
    private int[] hh, mm, ss;
    private String h1, h2, m1, m2, s1, s2;

    public BCDClock() {
        setLayout(null);
        Timer timer = new Timer();
        TimerTask timerTask = new TimerTask() {
            @Override
            public void run() {
                gc = new GregorianCalendar();
                hh = toBcdIndex(gc.get(Calendar.HOUR_OF_DAY));
                mm = toBcdIndex(gc.get(Calendar.MINUTE));
                ss = toBcdIndex(gc.get(Calendar.SECOND));
                h1 = kod_bcd[hh[0]];
                h2 = kod_bcd[hh[1]];
                m1 = kod_bcd[mm[0]];
                m2 = kod_bcd[mm[1]];
                s1 = kod_bcd[ss[0]];
                s2 = kod_bcd[ss[1]];
                repaint();
            }
        };
        timer.schedule(timerTask, 0, 1000);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.BLACK);
        g2.fillRect(0, 0, 210, 200);
        g2.setColor(Color.WHITE);
        g2.setFont(new Font("Dialog", Font.PLAIN, 9));
        g2.drawString("8", 6, 35);
        g2.drawString("4", 6, 55);
        g2.drawString("2", 6, 75);
        g2.drawString("1", 6, 95);
        g2.drawString("h", 40, 16);
        g2.drawString("m", 98, 16);
        g2.drawString("s", 158, 16);
        int i;
        int j = 20;
        for (i = 0; i < h1.length(); i++) {
            String c = h1.substring(i, i + 1);
            if (c.equals("0")) {
                g2.setColor(Color.WHITE);
            } else {
                g2.setColor(Color.RED);
            }
            g2.fillOval(i + 20, j, 20, 20);
            j += 20;
            if (j > 80) {
                j = 20;
            }
        }
        j = 20;
        for (i = 0; i < h2.length(); i++) {
            String c = h2.substring(i, i + 1);
            if (c.equals("0")) {
                g2.setColor(Color.WHITE);
            } else {
                g2.setColor(Color.RED);
            }
            g2.fillOval(i + 40, j, 20, 20);
            j += 20;
            if (j > 80) {
                j = 20;
            }
        }
        j = 20;
        for (i = 0; i < m1.length(); i++) {
            String c = m1.substring(i, i + 1);
            if (c.equals("0")) {
                g2.setColor(Color.WHITE);
            } else {
                g2.setColor(Color.RED);
            }
            g2.fillOval(i + 80, j, 20, 20);
            j += 20;
            if (j > 80) {
                j = 20;
            }
        }
        j = 20;
        for (i = 0; i < m2.length(); i++) {
            String c = m2.substring(i, i + 1);
            if (c.equals("0")) {
                g2.setColor(Color.WHITE);
            } else {
                g2.setColor(Color.RED);
            }
            g2.fillOval(i + 100, j, 20, 20);
            j += 20;
            if (j > 80) {
                j = 20;
            }
        }
        j = 20;
        for (i = 0; i < s1.length(); i++) {
            String c = s1.substring(i, i + 1);
            if (c.equals("0")) {
                g2.setColor(Color.WHITE);
            } else {
                g2.setColor(Color.RED);
            }
            g2.fillOval(i + 140, j, 20, 20);
            j += 20;
            if (j > 80) {
                j = 20;
            }
        }
        j = 20;
        for (i = 0; i < s2.length(); i++) {
            String c = s2.substring(i, i + 1);
            if (c.equals("0")) {
                g2.setColor(Color.WHITE);
            } else {
                g2.setColor(Color.RED);
            }
            g2.fillOval(i + 160, j, 20, 20);
            j += 20;
            if (j > 80) {
                j = 20;
            }
        }
    }

    @SuppressWarnings("ConstantConditions")
    public static int[] toBcdIndex(int jednCzasu) {
        int[] tabl = new int[2];
        if (jednCzasu < 10) {
            tabl[0] = 0;
            tabl[1] = jednCzasu;
        } else {
            String t = Integer.toString(jednCzasu);
            tabl[0] = Integer.parseInt(t.substring(0, 1));
            tabl[1] = Integer.parseInt(t.substring(1, 2));
        }
        return tabl;
    }
}
