<?php
/**
* Xaneon Extensions 2.0 for Mambo 4.5.2
* @copyright (c) 2004-2005 Xaneon Development (dev.xaneon.com)
* @license XPL http://dev.xaneon.com/xpl/
*/

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

// The Auto-Mapper creates human-friendly addresses for content items.

class xeSEFAutoMapper extends xeObject {
  var $replace = null;

  function xeSEFAutoMapper( &$db, &$config, &$site ) {
    $this->xeObject( $db, $config, $site );
    $this->replace = array(
    ' / ' => '/',
    ' ' => (!empty( $this->config->encode_space_char ) ?
      $this->config->encode_space_char : '_'),
    );
  }

  function map( $url ) { // static
    $title = $this->getContentPath( $url );
    $alias =& new mosSEFAlias( $this->db );
    $alias->site_id = $this->site->id;
    $alias->published = ($title ? '1' : '0');
    $alias->valid = '1';
    $alias->external = $title;
    $alias->internal = $url;
    $alias->hits = 0; // Auto-redirect will cause a hit...
    $alias->check();
    if (!$alias->store( false )) {
      // TODO: insert failed, should not happen. Are SQL tables missing??
      die( "DEBUG: row->store() failed!" );
    }
    return $alias;
  }

  function getContentURL( $item ) {
    if (is_numeric( $item )) {
      $id = $item;
      $item =& new mosContent( $this->db );
      $item->load( $id );
    }
    $title_field = $this->config->content_title_field;
    $title = ($title_field == 'title_alias' && $item->title_alias ?
      $item->title_alias : $item->title );
    return $this->encode( $title );
  }

  function getSectionURL( $item ) {
    if (is_numeric( $item )) {
      $id = $item;
      $item =& new mosSection( $this->db );
      $item->load( $id );
    }
    $title_field = $this->config->section_title_field;
    $title = ($title_field == 'name' && $item->name ?
      $item->name : $item->title);
    return $this->encode( $title );
  }

  function getCategoryURL( $item ) {
    if (is_numeric( $item )) {
      $id = $item;
      $item =& new mosCategory( $this->db );
      $item->load( $id );
    }
    $title_field = $this->config->category_title_field;
    $title = ($title_field == 'name' && $item->name ?
      $item->name : $item->title);
    return $this->encode( $title );
  }

  function getContentPath( $str ) {
    parse_str( $str, $info );

    $title_field = $this->config->content_title_field;
    $path_type = $this->config->content_path_type;
    $page_format = $this->config->content_page_format;
    if ($page_format == '') $page_format = '%s_%d';
    $page_suffix = $this->config->encode_page_suffix;

    $path = array();

    switch ($info['task']) {

      case 'view':
        $item =& new mosContent( $this->db );
        $item->load( $info['id'] );
        if ($path_type == 'full' || $path_type == 'section')
          $path[] = $this->getSectionURL( $item->sectionid );
        if ($path_type == 'full' || $path_type == 'category')
          $path[] = $this->getCategoryURL( $item->catid );

        $title = $this->getContentURL( $item );

        if (isset( $info['limit'] ) && isset( $info['limitstart'] )) {
          $page = $info['limitstart'];
          if (!is_numeric( $page ))
            return null;
          $page = (int)$page + 1;
          if ($page > 1) {
            $title = str_replace( array( '%s', '%d' ), array( $title, $page ), $page_format );
          }
          else {
            // TODO: should be able to set alias direction to outgoing only?
          }
        }

        $path[] = $title;
        $suffix = $page_suffix;

        break;

      // TODO: what about next/prev in views (section/category)? Hmm...

      // index.php?option=com_content&task=section&id=3&Itemid=40
      // index.php?option=com_content&task=blogsection&id=0&Itemid=39
      case 'section':
      case 'blogsection':
        if ($info['id']) {
          $path[] = $this->getSectionURL( $info['id'] );
          $suffix = '/';
        }
        break;

      // index.php?option=com_content&task=category&sectionid=3&id=7&Ite...
      case 'category':
      case 'blogcategory': // ?
        if ($info['id']) {
          $cat =& new mosCategory( $this->db );
          $cat->load( $info['id'] );
          if ($path_type == 'full' && $cat->section)
            $path[] = $this->getSectionURL( $cat->section );
          $path[] = $this->getCategoryURL( $cat );
          $suffix = '/';
        }
        break;

      default:
        break;
    }

    if (count( $path ) > 0) {
      //$url = $this->site->base_url;
      $url = '';
      foreach ($path as $item) {
        if ($item != '')
          $url .= '/' . $this->encode( $item );
      }
      if (!empty( $suffix ))
        $url .= $suffix;
      $url = str_replace( '//', '/', $url ); // Just in case...
      return $url;
    }

    return null;
  }

  // Credits go to jennings@trad.uji.es for the original version of this
  // incredibly useful little function!
  // For more information see http://php.net/manual/en/function.str-replace.php
  // Converts e.g. "Hll vr kkset!" => "Hello Everyone AakkOoset!"
  function unaccent( $text ) {
    // Get the HTML entities table into an array
    $trans = get_html_translation_table( HTML_ENTITIES );
    $search = array();
    $replace = array();
    // Go through the entity mappings one-by-one
    foreach ($trans as $literal => $entity) {
      // Make sure we don't process any other characters such as fractions,
      // quotes etc:
      if (ord( $literal ) >= 192) {
        // Get the accented form of the letter
        $search[] = $literal;
        // Get e.g. 'E' from string '&Eaccute'
        $replace[] = $entity[1];
      }
    }
    return str_replace( $search, $replace, $text );
  }

  function encode( $string ) {
    // Trim off any leading or trailing spaces
    $string = trim( $string );

    // Replace characters according to user-defined rules
    $string = str_replace(
      array_keys( $this->replace ),
      array_values( $this->replace ),
      $string );

    // Strip off any banned entities such !?# etc.
    if (!empty( $this->config->encode_strip_chars )) {
      $invalid = str_split( $this->config->encode_strip_chars, 1 );
      $string = str_replace( $invalid, '', $string );
    }

    // Convert e.g. "Hll vr" to "Hello Everyone"
    $string = xeSEFAutoMapper::unaccent( $string );

    // Make the text lowercase, unless the configuration says otherwise.
    if (!empty( $this->config->encode_lowercase ))
      $string = strtolower( $string );

    return $string;
  }

}

?>