<?php
/**
* @version $Id: index.php,v 1.5 2005/01/23 03:24:16 kochp Exp $
* @package Mambo
* @copyright (C) 2000 - 2005 Miro International Pty Ltd
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* Mambo is Free Software
*/

if (file_exists( "../configuration.php" ) && filesize( "../configuration.php" ) > 10) {
	header( "Location: ../index.php" );
	exit();
}
require_once ("../includes/version.php");

/** Include common.php */
include_once( "common.php" );

function get_php_setting($val) {
	$r =  (ini_get($val) == '1' ? 1 : 0);
	return $r ? 'ON' : 'OFF';
}

function writableCell( $folder ) {
	echo '<tr>';
	echo '<td class="item">' . $folder . '/</td>';
	echo '<td align="left">';
	echo is_writable( "../$folder" ) ? '<b><font color="green">Zapis moliwy</font></b>' : '<b><font color="red">Zapis nie jest moliwy</font></b>' . '</td>';
	echo '</tr>';
}

echo "<?xml version=\"1.0\" encoding=\"iso-8859-2\"?".">";
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Mambo - Web Installer</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-2" />
<link rel="shortcut icon" href="../../images/favicon.ico" />
<link rel="stylesheet" href="install.css" type="text/css" />
<script type="text/javascript">
<!--
var checkobj
function agreesubmit(el){
	checkobj=el
	if (document.all||document.getElementById){
		for (i=0;i<checkobj.form.length;i++){  //hunt down submit button
		var tempobj=checkobj.form.elements[i]
		if(tempobj.type.toLowerCase()=="submit")
		tempobj.disabled=!checkobj.checked
		}
	}
}

function defaultagree(el){
	if (!document.all&&!document.getElementById){
		if (window.checkobj&&checkobj.checked)
		return true
		else{
			alert("Prosz przeczyta/zaakceptowa licencj, aby kontynuowa instalacj")
			return false
		}
	}
}
//-->
</script>
</head>
<body>

<div id="wrapper">
<div id="header">
<div id="mambo"><img src="header_install.png" alt="Instalacja Mambo" /></div>
</div>
</div>

<div id="ctr" align="center">
<div class="install">
<div id="stepbar">
<div class="step-on">Test przedinstalacyjny</div>
<div class="step-off">Licencja</div>
<div class="step-off">Krok 1</div>
<div class="step-off">Krok 2</div>
<div class="step-off">Krok 3</div>
<div class="step-off">Krok 4</div>
</div>

<div id="right">

<div id="step">Test przedinstalacyjny</div>

<div class="far-right">
<input name="Button2" type="submit" class="button" value="Dalej >>" onclick="window.location='install.php';" />
</div>
<div class="clr"></div>

<h1>Test przedinstalacyjny dla <?php echo $version; ?>:</h1>
<div class="install-text">
Jeeli ktre z rozpoznanych ustawie wywietlane jest
w kolorze czerwonym, popraw je.<br />
Mambo nie mona zainstalowa przy pomocy kreatora,
jeli niespenione s odpowiednie wymagania. 
<div class="ctr"></div>
</div>

<div class="install-form">
<div class="form-block">

<table class="content">
<tr>
	<td class="item">
	PHP version >= 4.1.0
	</td>
	<td align="left">
	<?php echo phpversion() < '4.1' ? '<b><font color="red">Nie</font></b>' : '<b><font color="green">Tak</font></b>';?>
	</td>
</tr>
<tr>
	<td>
	&nbsp; - kompresja zlib
	</td>
	<td align="left">
	<?php echo extension_loaded('zlib') ? '<b><font color="green">Dostpna</font></b>' : '<b><font color="red">Niedostpna</font></b>';?>
	</td>
</tr>
<tr>
	<td>
	&nbsp; - wsparcie XML
	</td>
	<td align="left">
	<?php echo extension_loaded('xml') ? '<b><font color="green">Dostpne</font></b>' : '<b><font color="red">Niedostpne</font></b>';?>
	</td>
</tr>
<tr>
	<td>
	&nbsp; - obsuga MySQL
	</td>
	<td align="left">
	<?php echo function_exists( 'mysql_connect' ) ? '<b><font color="green">Dostpna</font></b>' : '<b><font color="red">Niedostpna</font></b>';?>
	</td>
</tr>
<tr>
	<td valign="top" class="item">
	configuration.php
	</td>
	<td align="left">
	<?php
	if (@file_exists('../configuration.php') &&  @is_writable( '../configuration.php' )){
		echo '<b><font color="green">Zapisywalny</font></b>';
	} else if (is_writable( '..' )) {
		echo '<b><font color="green">Zapisywalny</font></b>';
	} else {
		echo '<b><font color="red">Niezapisywalny</font></b><br /><span class="small">W tym przypadku moesz kontynuowa instalacj. Gdy proces instalacji zostanie zakoczony, kreator instalacji wywietli wszystkie zmienne konfiguracyjne. Skopiujesz je i wkleisz do pliku configuration.php na serwerze.</span>';
    } ?>
	</td>
</tr>
<tr>
	<td class="item">
	cieka do zmiennej sesji
	</td>
	<td align="left">
	<b><?php echo (($sp=ini_get('session.save_path'))?$sp:'Not set'); ?></b>,
	<?php echo is_writable( $sp ) ? '<b><font color="green">Zapisywalna</font></b>' : '<b><font color="red">Niezapisywalna</font></b>';?>
	</td>
</tr>
</table>
</div>
</div>
<div class="clr"></div>

<h1>Zalecane ustawienia:</h1>
<div class="install-text">
Dla penej zgodnoci z Mambo zalecane s nastpujce ustawienia serwera.<br />
Nawet jeli Twoje rodowisko nie spenia ich wszystkich,
Mambo zostanie zainstalowane i powinno poprawnie funkcjonowa. 
<div class="ctr"></div>
</div>

<div class="install-form">
<div class="form-block">

<table class="content">
<tr>
	<td class="toggle">
	Dyrektywa
	</td>
	<td class="toggle">
	Zalecana
	</td>
	<td class="toggle">
	Obecna
	</td>
</tr>
<?php
$php_recommended_settings = array(array ('Safe Mode','safe_mode','OFF'),
array ('Display Errors','display_errors','ON'),
array ('File Uploads','file_uploads','ON'),
array ('Magic Quotes GPC','magic_quotes_gpc','ON'),
array ('Magic Quotes Runtime','magic_quotes_runtime','OFF'),
array ('Register Globals','register_globals','OFF'),
array ('Output Buffering','output_buffering','OFF'),
array ('Session auto start','session.auto_start','OFF'),
);

foreach ($php_recommended_settings as $phprec) {
?>
<tr>
	<td class="item"><?php echo $phprec[0]; ?>:</td>
	<td class="toggle"><?php echo $phprec[2]; ?>:</td>
	<td>
	<?php
	if ( get_php_setting($phprec[1]) == $phprec[2] ) {
	?>
		<font color="green"><b>
	<?php
	} else {
	?>
		<font color="red"><b>
	<?php
	}
	echo get_php_setting($phprec[1]);
	?>
	</b></font>
	<td>
</tr>
<?php
}
?>
</table>
</div>
</div>
<div class="clr"></div>

<h1>Prawa dostpu do plikw i katalogw:</h1>
<div class="install-text">
Aby Mambo dziaa poprawnie, musi dokonywa wpisw
w pewnych katalogach i plikach.<br />
Jeeli widzisz gdzie uwag, e zapisywanie do katalogu
jest niemoliwe, musisz zmieni prawa dostpu do tego katalogu. 
<div class="clr">&nbsp;&nbsp;</div>
<div class="ctr"></div>
</div>

<div class="install-form">
<div class="form-block">

<table class="content">
<?php
writableCell( 'administrator/backups' );
writableCell( 'administrator/components' );
writableCell( 'administrator/modules' );
writableCell( 'administrator/templates' );
writableCell( 'cache' );
writableCell( 'components' );
writableCell( 'images' );
writableCell( 'images/banners' );
writableCell( 'images/stories' );
writableCell( 'language' );
writableCell( 'mambots' );
writableCell( 'mambots/content' );
writableCell( 'mambots/search' );
writableCell( 'media' );
writableCell( 'modules' );
writableCell( 'templates' );
?>
</table>
</div>
<div class="clr"></div>
</div>
<div class="clr"></div>
</div>
<div class="clr"></div>
</div>
</div>

<div class="ctr">
Miro International Pty Ltd. &copy; 2000 - 2005 Wszelkie prawa zastrzeone.<br />
<a href="http://www.mamboserver.com" target="_blank">Mambo</a> jest Darmowym Oprogramowaniem rozpowszechnianym na warunkach licencji GNU/GPL. 
</div>

</body>
</html>
