<?php
// MambelFish - Mambos Babelfish
// Copyright (C) 2003-2005 Think Network GmbH
// All rights reserved.  The mambel fish project is a extention hack and
// component for the Mambo Open Server. It enables Mambo OS to handle multi
// lingual sites especially in all dynamic contents which are stored in the
// database.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html
// --------------------------------------------------------------------------------
// $Id: mambelfish.class.php,v 1.3 2005/03/13 22:01:23 akede Exp $
//

/**
* @package mambelfish.classes
* @copyright 2003-2005 Think Network GmbH
* @license http://www.gnu.org/copyleft/gpl.html GNU Public License
* @version 1.0, 2003-10-16 $Revision: 1.3 $
* @author Alex Kempkens <akede@users.sourceforge.net>
*/

// ensure this file is being included by a parent file
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

/**
 * The mambel fish change the text information in the supported
 * objects after they have been loaded. The idea is to create a
 * flexible environment which can add the multi language support at
 * any time.</p>
 *
 * The basic concept behind the mambel fish is to map an existing content
 * with all his general information to a different translation of it's
 * text content. There is no additional copy of the information like the
 * author or publishing flags, only a copy of the text fields.
 *
 * @author	A. Kempkens
 */
class MambelFish {

	/** The function tries to find out which language we should use for the web site
	 * 
	 * It is possible to choose the language based on the client browsers configuration,
	 * the activated language of the configuration and the language a user has choosen in
	 * the past. The decision of this order is done in the MambelFish configuration.
	 * 
	 * The other topic while choosing the language is to change the $mosConfig_lang var 
	 * for the other CMT's and same this for the user in the session or cockie.
	 */
	function discoverLanguage ( &$database ) {
		global $mosConfig_lang, $GLOBALS, $_SERVER;
		
		
		$mbfcookie = mosGetParam( $_COOKIE, 'mbfcookie', null );
		if (isset($mbfcookie["lang"]) && $mbfcookie["lang"] != "") {
			$client_lang = $mbfcookie["lang"];
		} else {
			$client_lang = '';
		}
		
		if (array_key_exists('lang', $_GET) && $_GET["lang"] != '') {
			$client_lang = $_GET["lang"];
			
			// Check if we have a referer and go back to the page and the option/ItemID are not set
			if ( !isset($option) || $option=='' ) {
				$httpReferer = '';
				if( in_array( 'HTTP_REFERER', $_SERVER) ) {
					$httpReferer = $_SERVER["HTTP_REFERER"];
				}
				
				$splittedReferer = explode ( '?', $httpReferer );
				if ( isset($splittedReferer[1]) ) {
					$uri = explode( '&', $splittedReferer[1] );
					
					foreach ($uri as $key => $value) {
						// this value is still including the '='
						list( $uriKey, $uriValue ) = explode( '=', $value );
			
						if ($uriKey=="option") {
							$option = $uriValue;
						}
						if ($uriKey=="task") {
							$task = $uriValue;
						}
						if ($uriKey=="id") {
							$id = $uriValue;
						}
						if ($uriKey=="Itemid") {
							$Itemid = $uriValue;
						}
					}
				}
			}
		// no language chooses - assume from browser configuration
		} else if ($_SERVER["HTTP_ACCEPT_LANGUAGE"] != "" && $client_lang=='') {
			// language negotiation by Kochin Chang, June 16, 2004
			// retrieve active languages from database
			$active_lang = null;
			$activeLanguages = MambelFishManager::getActiveLanguages();
			if( count( $activeLanguages ) == 0 ) {
				return $mosConfig_lang;
			}
			
			foreach ($activeLanguages as $lang) {
				$active_lang[] = $lang->iso;
			}

			// figure out which language to use
			$browserLang = explode(',', $_SERVER["HTTP_ACCEPT_LANGUAGE"]);
			
			foreach( $browserLang as $lang ) {
				$shortLang = substr( $lang, 0, 2 );
				
				if( in_array($lang, $active_lang) ) {
					$client_lang = $lang;
					break;
				}
				
				if ( in_array($shortLang, $active_lang) ) {
					$client_lang = $shortLang;
					break;
				}
			}
		}
		
		// get the name of the language file for mambo
		$mbfLang = new mbfLanguage($database);
		$mbfLang->loadByISO( $client_lang );
		
		if( isset($mbfLang) && $mbfLang->mambo != "" & $mbfLang->active) {
			$mosConfig_lang = $mbfLang->mambo;
		} else {
			$mbfLang->loadByMambo( $mosConfig_lang );
			$client_lang = $mbfLang->iso;
		}
		
		// set locale for this ISO code
		setlocale(LC_ALL, $client_lang);
		
		setcookie( "lang", "", time() - 1800, "/" );
		setcookie( "mbfcookie", "", time() - 1800, "/" );
		setcookie( "mbfcookie[lang]", $client_lang, time()+24*3600, '/' );
		return $client_lang;
	}

	/** Translate a list of items
	 *
	 */
	function translateList( $rows, $reference_table, $language ) {
		foreach( array_keys( $rows) as $key ) {
			$row =& $rows[$key];

			// Overwrites the language when a row contains certain language information
			if( isset($row->mbflang) && $row->mbflang != "" ) {
				$language = $row->mbflang;
			}
			
			$row = MambelFish::translate( $row, $reference_table, $language);
		}
		
		return $rows;
	}
	
	/** Cover function which tries to find out the id from the object
	 *
	 */
 	 function translate( $content, $reference_table, $language ) {
 	 	if( isset( $content->id ) ) {
		 	$id = $content->id;
			return MambelFish::translateWithID( $content, $id, $reference_table, $language );
 	 	} else {
 	 		return $content;
 	 	}
	 }


	 /**
	  * Function to translate a section object
	  */
	 function translateWithID( $content, $id, $reference_table, $language )
	 {
	 	global $database, $mosConfig_debug, $mosConfig_defaultLang, $_MAMBELFISH_MANAGER;
	 	
	 	// Default, we change nothing because we didn't found anything better
	 	$result = $content;

	 	if ($reference_table == "mbf_language" || $reference_table == "mbf_content" ) {
	 		return $content;					// I can't translate myself ;-)
	 		
	 	} elseif ($reference_table == '') {
			switch (get_class($content)) {
				case 'mosCategory':
					$reference_table='categories';
					break;
				
				case 'mosSection':
					$reference_table='sections';
					break;
				
				case 'mosContent':
					$reference_table='content';
					break;
				
				case 'mosMenu':
					$reference_table='menu';
					break;
				
				default:
					$reference_table='%';
			}
		}
		
		if ($mosConfig_debug) {
			echo "<strong>MambelFish debug:</strong><br>"
			. "name=" .$content->name. "<br>"
			. "id=$id<br>"
			. "reference_table=$reference_table<br>"
			. "language=$language<br>"
			. "class=" .get_class($content). "</p>";
		}

		if (isset($id) && $id>=0 && $reference_table!='') {
			$sql = "SELECT mbf_content.reference_field, mbf_content.value"
			. "\nFROM #__mbf_content AS mbf_content,"
			. "\n   #__mbf_language as mbf_language"
			. "\nWHERE mbf_content.language_id=mbf_language.id"
			. "\n	AND mbf_content.published=1"
			. "\n   AND mbf_content.reference_id='$id'"
			. "\n   AND mbf_content.reference_table='$reference_table'"
			. "\n	AND mbf_language.mambo='$language'";
			$database->setQuery( $sql );
			$fieldValues = $database->loadObjectList();
			
			if( count($fieldValues) > 0 ) {
				foreach ($fieldValues as $row) {
					if (is_subclass_of($result, 'mosDBTable')) {
						$result->set($row->reference_field, $row->value);
					} else {
						$refField = $row->reference_field;
						$result->$refField = $row->value;
					}
		      	}
			} else {
				
				if( $_MAMBELFISH_MANAGER->getCfg( 'noTranslation' ) == 1 && $language != $mosConfig_defaultLang ) {
					$contentElement = $_MAMBELFISH_MANAGER->getContentElement( $reference_table );
					if( isset($contentElement) && $contentElement->getReferenceType() == $_MAMBELFISH_MANAGER->DEFAULT_CONTENTTYPE ) {
						$contentObject = new ContentObject( $_MAMBELFISH_MANAGER->getLanguageID($language), $contentElement );
						$textFields = $contentObject->getTextFields();
						if( $textFields !== null ) {
							$defaultSet = false;
							foreach ($textFields as $field) {
								if( !$defaultSet ) {
									$result->$field = $_MAMBELFISH_MANAGER->getCfg('defaultText');
									$defaultSet = true;
								} else {
									$result->$field = "";
								}
							}
						}
					}
				}
			}
			
		}
		return $result;
	 }
	 
	 /**
	  * Version information of the component
	  *
	  * @author	Alex Kempkens
	  */
	 function version() {
	 	return MambelFishManager :: getVersion();
	 }
}

?>
