<?php 
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' ); 
/**
* @version $Id: ps_session.php,v 1.5 2005/01/27 19:33:40 soeren_nb Exp $
* @package mambo-phpShop
* Contains code from PHPShop(tm):
* 	@copyright (C) 2000 - 2004 Edikon Corporation (www.edikon.com)
*	Community: www.phpshop.org, forums.phpshop.org
* Conversion to Mambo and the rest:
* 	@copyright (C) 2004-2005 Soeren Eberhardt
*
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* mambo-phpShop is Free Software.
* mambo-phpShop comes with absolute no warranty.
*
* www.mambo-phpshop.net
*/

/****************************************************************************
* CLASS DESCRIPTION
*                   
* ps_session
*
* The class is the former session class for phpshop
* NOTE: THIS CLASS HAS NO SESSION FUNCTIONALITIES ANY MORE
* THE ONLY FUNCTIONS NEEDED ARE 
* url() 
AND 
* purl()
*
*************************************************************************/
class ps_session {
  var $classname = "ps_session";
  var $component_name = "option=com_phpshop";

  
  /**************************************************************************
  ** name: url()
  ** created by:
  ** description:
  ** parameters:
  ** returns: an URL concatenated with "option=com_phpshop"
  ***************************************************************************/  
  function url($text) {
    global $mosConfig_sef;
    
    $Itemid = isset( $_REQUEST['Itemid'] ) ? $_REQUEST['Itemid'] : "";
    switch ($text) {
        case SECUREURL:
            $text =  SECUREURL.$_SERVER['PHP_SELF']."?".$this->component_name."&Itemid=".$Itemid;
            break;
        case URL:
            $text =  URL.$_SERVER['PHP_SELF']."?".$this->component_name."&Itemid=".$Itemid;
            break;
        default:
            $limiter = strpos($text, '?');
            
            // now append "&option=com_phpshop&Itemid=XX"
            $appendix = "&" . $this->component_name."&Itemid=".$Itemid;
            
            if (!defined( '_PSHOP_ADMIN' )) {
                // be sure that we have "index.php" in front of the url
                $appendix = "index.php".substr($text, $limiter, strlen($text)-1).$appendix;
                $appendix = sefRelToAbs ( $appendix );
                if( !stristr( $appendix, URL ) )
                    $appendix = URL . $appendix;
            } 
            else
                $appendix = URL."administrator/index2.php".substr($text, $limiter, strlen($text)-1).$appendix;
                
            if ( stristr($text, SECUREURL))
                $appendix = str_replace(URL, SECUREURL, $appendix);
                
            $text = $appendix;

            break;
    }
    return $text;
  }
  
   /**************************************************************************
  ** name: url()
  ** created by:
  ** description:
  ** parameters:
  ** returns: echoes an URL concatenated with the string "option=com_phpshop"
  ***************************************************************************/  
  
  function purl($text) {

    $Itemid = isset( $_REQUEST['Itemid'] ) ? $_REQUEST['Itemid'] : "";
    switch ($text) {
        case SECUREURL:
            $text =  SECUREURL.$_SERVER['PHP_SELF']."?".$this->component_name."&Itemid=".$Itemid;
            break;
        case URL:
            $text =  URL.$_SERVER['PHP_SELF']."?".$this->component_name."&Itemid=".$Itemid;
            break;
        default:
            $limiter = strpos($text, '?');
            
            // now append "&option=com_phpshop&Itemid=XX"
            $appendix = "&" . $this->component_name."&Itemid=".$Itemid;
            
            if (!defined( '_PSHOP_ADMIN' )) {
                // be sure that we have "index.php" in front of the url
                $appendix = "index.php".substr($text, $limiter, strlen($text)-1).$appendix;
                $appendix = sefRelToAbs ( $appendix );
                if( !stristr( $appendix, URL ) )
                    $appendix = URL . $appendix;
            } 
            else
                $appendix = URL."administrator/index2.php".substr($text, $limiter, strlen($text)-1).$appendix;
            
            if ( stristr($text, SECUREURL))
                $appendix = str_replace(URL, SECUREURL, $appendix);
                
            $text = $appendix;

            break;
    }
    echo $text;
  }

  
/**************************************************************************
  ** name: hidden_session()
  ** created by:
  ** description:
  ** parameters:
  ** returns: nothing
  ***************************************************************************/  
  
  function hidden_session() {
    return true;
  }


} // end of class session
?>
