<?php
/**
* Xaneon Alias Manager 1.0 for Mambo 4.5.1
* @package Alias_Manager_1.0
* @version 1.0.3a
* @copyright (c) 2004 Xaneon Development (dev.xaneon.com)
* @license GNU/GPL
*/

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

error_reporting( E_ALL );

function com_install() {
  global $database, $mosConfig_absolute_path, $mosConfig_sef, $mosConfig_live_site;

  $admin_path = "$mosConfig_absolute_path/administrator/components/com_alias";
  $sef_path = "$mosConfig_absolute_path/components/com_sef";
  $alias_path = "$mosConfig_absolute_path/components/com_alias";

  ob_start();
  ?>
  <a href="http://dev.xaneon.com/" target="_blank"><img
    alt="Xaneon Development"
    src="http://dev.xaneon.com/images/logos/alias-1.0.3a.gif"
    border="0" /></a>
  <?php

  if (true) {
    // Windows-safe installation. Creates the SEF hook directory and
    // copies the necessary files. These files will then need to be removed
    // in the uninstallation script.
    if (!file_exists( $sef_path )) {
      @mkdir( $sef_path, 0777 );
    }
    if (!@copy( "$alias_path/sef.php", "$sef_path/sef.php" )) {
      ?>
      <p><div style="color: red;">WARNING! Installing the SEF hook failed.
        Please consult the installation manual.</div></p>
      <?php
    }
  }
  else {
    // TODO: Unix-specific installation using a directory symlink.
  }

  if (true) {
    // Check if SEF is disabled in Mambo's global configuration
    if ($mosConfig_sef != '1') {
    ?>  
      <p><span style="color: red; font-weight: bold;">WARNING!</span>
      SEF is currently disabled in Mambo's
      <a href="index2.php?option=com_config">Global Configuration</a>.
      Alias Manager will not function unless you enable it.</p>
    <?php
    } // if $mosConfig_sef
    // Check if htaccess.txt has been renamed to .htaccess
    $htaccess_file = "$mosConfig_absolute_path/.htaccess";
    if (!file_exists( $htaccess_file )) {
    ?>  
      <p><span style="color: red; font-weight: bold;">WARNING!</span>
      The file <?php echo( $htaccess_file ); ?>
      does not exist. Please rename htaccess.txt to .htaccess,
      otherwise Alias Manager will not function.</p>
    <?php
    } // if !file_exists
  }

  // TODO: Check that the mod_rewrite Apache module is loaded.

  // Take Mambo's base URL and save into our configuration.
  if (true) {
    // Make sure the configuration file is writable.
    $config_file = "$admin_path/alias.config.php";
    if (!is_writable( $config_file )) @chmod( $config_file, 0666 );

    require_once( "$admin_path/alias.class.php" );
    $mambo_base_url = strchr( substr( $mosConfig_live_site, strlen( "http://" ) + 1 ), "/" );
    if ($mambo_base_url !== false) {
      $config = new mosAliasConfig();
      $config->base_url = $mambo_base_url;
      $config->store();
    }
  }

  if (true) {
    // Fix the admin menu.
    $queries = array(
      "UPDATE #__components SET `admin_menu_link` = ''"
        ."\nWHERE `option` = 'com_alias' AND `parent` = 0",
      "UPDATE #__components SET `admin_menu_img` = 'js/ThemeOffice/edit.png'"
        ."\nWHERE `admin_menu_link` = 'option=com_alias&task=aliases'",
      "UPDATE #__components SET `admin_menu_img` = 'js/ThemeOffice/credits.png'"
        ."\nWHERE `admin_menu_link` = 'option=com_alias&task=about'",
    );
    foreach ($queries as $query) {
      $database->setQuery( $query );
      $result = $database->query();
    }
  }

  ?>
  <p><div style="color: green;">Xaneon Alias Manager
  successfully installed.</div></p>
  <p>After the installation, you can access Alias Manager by selecting
  Components -> Aliases -> <a href="index2.php?option=com_alias">Manage Aliases</a>
  from Mambo's administrative menu.</p>
  <p>This component is released under the terms and conditions of the
  GNU General Public License.
  For documentation and support, please visit the product website at
  <a href="http://dev.xaneon.com/products/alias/"
    target="_blank">http://dev.xaneon.com/products/alias/</a></p>
  <p>Thank you for installing Xaneon Alias Manager!</p>
  <p><br /></p>
  <?php
  $output = ob_get_contents();
  ob_end_clean();
  return $output;
}

?>