<?php
/**
* Xaneon Alias Manager 1.0 for Mambo 4.5.1
* @package Alias_Manager_1.0
* @version 1.0.3a
* @copyright (c) 2004 Xaneon Development (dev.xaneon.com)
* @license GNU/GPL
*/

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

/**
*
*/
class HTML_alias {

  function printVersion() {
  ?>
    <div align="center">
    Alias Manager 1.0.3a by <a href="http://dev.xaneon.com/"
      target="_blank">Xaneon Development</a>
    </div>
  <?php
  }

  function errorGoBack( $msg ) {
  ?>
    <script language="JavaScript">alert('<?php echo( $msg ); ?>'); window.history.go(-1);</script>
  <?php
  }

  function printText( $msg, $color = null ) {
    if (!$color) {
      echo( $msg );
    }
    else {
      echo( "<span style=\"color:$color\">$msg</span>" );
    }
  }

  function printLine( $msg = null, $color = null, $indent = 0 ) {
    if ($indent > 0) {
      for ($i = 0; $i < $indent; $i++) echo( "&nbsp;" );
    }
    if ($msg) {
      HTML_alias::printText( $msg, $color );
    }
    echo( "<br />\n" );
  }

  function continueButton ( $url, $title = "Continue" ) {
  ?>
    <p><input type="button" value="<?php echo( $title ); ?>"
      onclick="location.href='<?php echo( $url ); ?>';" />
    <br /><br />
  <?php
  }

  function beginOutput( $title, $pic = "browser" ) {
  ?>
    <table class="adminheading" width="100%">
    <tr>
      <th class="<?php echo( $pic ); ?>">&nbsp;<?php echo( $title ); ?></th>
    </tr>
    <tr>
      <td valign="top" align="left">
      <br />
  <?php
  }

  function endOutput() {
  ?>
      </td>
    </tr>
    </table>
  <?php
  }

  function aliasAboutPage( $option, &$config ) {
    ?>
    <table class="adminheading" width="100%">
    <tr>
      <th class="browser">&nbsp;About Alias Manager</th>
    </tr>
    </table>
    <br />
    <table class="" cellpadding="5" cellspacing="0" width="100%" border="0">
    <tr>
      <td valign="top" align="left">
        <table cellpadding="0" cellspacing="0">
        <tr>
          <td valign="top" align="left">
            <b>Xaneon Alias Manager 1.0.3a for Mambo 4.5.1</b><br />
            Written by Arto Bendiken (arto@xaneon.com)<br />
            Copyright &copy; 2004 Xaneon Development. All rights reserved.<br />
            <br /><a href="http://dev.xaneon.com/products/alias/"
              target="_blank">http://dev.xaneon.com/products/alias/</a>
          </td>
          <td valign="top">&nbsp;</td>
          <td valign="top" align="left"><a
            href="http://dev.xaneon.com/products/alias/" target="_blank"><img
            alt="Xaneon Alias Manager" align="right" hspace="10"
            src="http://dev.xaneon.com/images/boxes/alias-1.0.3a.gif"
            border="0" /></a></td>
        </tr>
        </table>

        <p><b>About Alias Manager</b></p>
        <blockquote>
        <p>Alias Manager is a Mambo 4.5.1 component that taps into Mambo's SEF (Search
        Engine Friendly) URL mechanism and extends it by allowing you to define your
        own arbitary, friendly URLs for any of Mambo's content and component items.</p>
        </blockquote>

        <p><b>Related Links</b></p>
        <blockquote>
        <p>
        <li><a href="http://dev.xaneon.com/products/alias/download.html" target="_blank">Latest Version</a></li>
        <li><a href="http://dev.xaneon.com/products/alias/faq.html" target="_blank">Frequently Asked Questions (FAQ)</a></li>
        <li><a href="http://dev.xaneon.com/products/alias/manual.html" target="_blank">User Manual</a></li>
        <li><a href="http://dev.xaneon.com/forum/alias/" target="_blank">Support Forum</a></li>
        <li><a href="http://mamboforge.net/projects/alias/" target="_blank">Development Site</a></li>
        </p>
        </blockquote>

        <p><b>Bug Reports</b></p>
        <blockquote>
        <p>Please report any bugs to the project's MamboForge
        <a href="http://mamboforge.net/tracker/?atid=2244&group_id=634&func=browse"
          target="_blank">Bug Tracker</a>.</p>
        </blockquote>

        <p><b>Credits</b></p>
        <blockquote>
        <p>The Xaneon Development Team would like to kindly thank the following
        individuals for their contributions to the development of this software:
        <li>Pam, Nic, Betsy and everyone else on our support forum
          <i>- For lots and lots of invaluable suggestions.</i></li>
        <li>Senthil Nachimuthu, University of Utah (nachimuthu@gmail.com)
          <i>- For contributing a bug fix.</i></li>
        </p>
        </blockquote>

        <p><b>Legal Stuff</b></p>
        <blockquote>
        <p>This software is released under the terms and conditions of the
        <a href="http://www.gnu.org/copyleft/gpl.html" target="_blank">GNU General Public License</a>.</p>
        </blockquote>
      </td>
    </tr>
    </table>
  <?php
    HTML_alias::printVersion();
  } // function aliasAboutPage

  function getLanguageList() {
    // Based on code from com_config
    global $mosConfig_absolute_path;
    require_once( "$mosConfig_absolute_path/administrator/components/com_alias/alias.langs.php" );
    $langs = array();
    if ($handle = opendir( "$mosConfig_absolute_path/language/" )) {
      $i = 0;
      while (false !== ($file = readdir( $handle ))) {
        if ($file <> "." && $file <> "..") {
          if (!strcasecmp( substr( $file, -4 ), ".php" )
              && strcasecmp( substr( $file, -11 ), ".ignore.php" )) {
            $langName = substr( $file, 0, -4 );
            if (($langCode = sefGetLangISOCode( $langName )) != '') {
              $langTitle = sefGetLangTitle( $langCode );
              $langs[] = mosHTML::makeOption( $langCode, $langTitle );
            }
          }
        }
      }
    }
    sort($langs);
    reset($langs);
    return $langs;
  }

  function aliasView( &$rows, $pageNav, $search, $language, $option, &$config ) {
    global $mosConfig_live_site, $mosConfig_absolute_path, $mosConfig_sef;
    $tabs = new mosTabs( 0 );
  ?>
    <script language="JavaScript" src="<?php echo( $mosConfig_live_site ); ?>/includes/js/overlib_mini.js"></script>
    <div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
    <form action="index2.php" method="post" name="adminForm">

    <table class="adminheading" width="100%">
    <tr>
      <th class="browser">&nbsp;Manage Aliases</th>
      <td>Language&nbsp;Filter:&nbsp;</td>
      <td width="right">
      <?php
        $alias_langs = array();
        $alias_langs[] = mosHTML::makeOption( "*", "(All)" );
        $alias_langs[] = mosHTML::makeOption( "-", "(Default)" );
        $alias_langs = array_merge( $alias_langs, HTML_alias::getLanguageList() );
        echo( mosHTML::selectList( $alias_langs, "language",
            'class="inputbox" size="1" onchange="document.adminForm.submit();"',
            "value", "text", $language ) );
      ?>
      </td>
      <td>&nbsp;&nbsp;</td>
      <td>Search:&nbsp;</td>
      <td><input type="text" name="search" value="<?php echo( $search ); ?>"
        class="inputbox" onChange="document.adminForm.submit();" /></td>
    </tr>
    </table>

    <table class="" width="100%">
    <tr>
      <td width="65%" valign="top" align="left">
        <table class="adminlist" width="100%">
        <tr>
          <th width="20">#</th>
          <th width="25" class="title"><input type="checkbox" name="toggle" value=""
            onClick="checkAll(<?php echo( count( $rows ) ); ?>);" /></th>
          <th width="40%" class="title">URL Alias</th>
          <th width="52%" class="title">URL Target</th>
          <th width="8%" class="title">Published</th>
        </tr>
      <?php
      if (count( $rows ) > 0) {
      ?>
        <?php
        for ($i = 0, $n = count( $rows ); $i < $n; $i++) {
          $row =& $rows[$i];
          //mosMakeHtmlSafe( $row, ENT_QUOTES );
        ?>
        <tr class="<?php echo( "row" . ($i % 2 == 0 ? 0 : 1) ); ?>">
          <td><?php echo( $i + 1 + $pageNav->limitstart ); ?></td>
          <td align="left"><?php echo( mosHTML::idBox( $i, $row->id ) ); ?></td>
          <td align="left"><a href="#edit" onClick="return listItemTask('cb<?php echo( $i ); ?>', 'edit')">
            <?php echo( $row->url ); ?></a> </td>
          <td align="left"><?php echo( $row->target ); ?></td>
          <td align="center">
          <?php if ($row->published == '1') { ?>
            <a href="#" onclick="return listItemTask('cb<?php echo( $i ); ?>', 'unpublish');"><img
              alt="Published" src="images/tick.png"
              width="12" height="12" border="0" /></a>
          <?php } else { ?>
            <a href="#" onclick="return listItemTask('cb<?php echo( $i ); ?>', 'publish');"><img
              alt="Unpublished" src="images/publish_x.png"
              width="12" height="12" border="0" /></a>
          <?php } ?>
          </td>
        </tr>
        <?php
        } // for $rows
        ?>
      <?php
      } // if count $rows
      else {
      ?>
        <tr>
          <td colspan="5">
            <b>Getting Started:</b>
            To create Search Engine Friendly URL addresses, either use the
            <b>New</b> button, or, if you wish to create several URLs at
            once, the <b>Import</b> tab to the right.</p>
          </td>
        </tr>
      <?php
      }
      ?>
        </table>
        <?php echo( $pageNav->getListFooter() ); ?>
      </td>
      <td width="35%" valign="top">
        <?php
        $tabs->startPane( "content-pane" );
        $tabs->startTab( "General", "general-page" );
        ?>
        <table class="adminform" width="100%">
        <tr>
          <th colspan="4">Basic Settings</th>
        </tr>
        <tr>
          <td valign="top" align="right" nowrap="1">Enable Alias Manager:&nbsp;</td>
          <td><?php echo( mosHTML::yesnoSelectList( "config_enabled", 'class="inputbox"', $config->enabled ) ); ?></td>
          <td><?php echo( mosToolTip( "Set this to enable or disable Alias Manager. When disabled, Mambo will revert to using its standard SEF URLs.", "Enable Aliases" ) ); ?></td>
          <td width="100%">&nbsp;</td>
        </tr>
        <tr>
          <td valign="top" align="right" nowrap="1">Generate Absolute URLs:&nbsp;</td>
          <td><?php echo( mosHTML::yesnoSelectList( "config_absolute_urls", 'class="inputbox"', $config->absolute_urls ) ); ?></td>
          <td><?php echo( mosToolTip( "Whether to always output absolute URLs by prepending them with &quot;$mosConfig_live_site&quot;. This is unnecessary for most users.", "Absolute URLs" ) ); ?></td>
          <td>&nbsp;</td>
        </tr>
        <tr>
          <td valign="top" align="right" nowrap="1">Mambo Base URL:&nbsp;</td>
          <td><input name="config_base_url" type="textbox" class="inputbox" size="10" value="<?php echo( $config->base_url ); ?>" /></td>
          <td><?php echo( mosToolTip( "If you installed Mambo in the root of a website, leave this empty; otherwise you should write your subdirectory, e.g. /mambo451", "Mambo Base URL" ) ); ?></td>
          <td>&nbsp;</td>
        </tr>
        <tr>
          <td colspan="4">
            <input type="button" value="Update Settings" onclick="submitform('config');" />
          </td>
        </tr>
        <tr>
          <td colspan="4">&nbsp;</th>
        </tr>
        <tr>
          <th colspan="4">Compatibility Check</th>
        </tr>
        <tr>
          <td valign="top" align="right" nowrap="1">Apache Version:&nbsp;</td>
          <?php
          $server_info = $_SERVER["SERVER_SOFTWARE"];
          $server_short = strpos( $server_info, ' ') === false ?
            $server_info : substr( $server_info, 0, strpos( $server_info, ' ' ) );
          $status = strpos( $server_info, "Apache" ) === false ?
            "WARNING" : "OK";
          ?>
          <td colspan="3">
            <span style="color: <?php echo( $status == "OK" ? "green" : "red" );
              ?>; font-weight: bold;"><?php echo( $status ); ?></span>
            (<?php echo( str_replace( "Apache/", "", $server_short ) ); ?>)&nbsp;
            <?php
            if ($status != "OK") {
              echo( mosWarning(
                "You are running a possibly unsupported web server."
                  ." Alias Manager currently only functions on Apache web servers.",
                "Unsupported Web Server" ) );
            }
            ?>
          </td>
        </tr>
        <tr>
          <td valign="top" align="right" nowrap="1">PHP Version:&nbsp;</td>
          <?php
          $status = "OK";
          ?>
          <td colspan="3">
            <span style="color: <?php echo( $status == "OK" ? "green" : "red" );
              ?>; font-weight: bold;"><?php echo( $status ); ?></span>
            (<?php echo( phpversion() ); ?>)&nbsp;
          </td>
        </tr>
        <tr>
          <td valign="top" align="right" nowrap="1">Mambo Version:&nbsp;</td>
          <?php
          // Designed for "Version: Mambo 4.5.1a Stable [Three For Rum]"
          global $version;
          $version_info = explode( " ", $version );
          $version_pos = array_search( "Mambo", $version_info );
          $version_str = ($version_pos === false ? "4.5.1?" : $version_info[$version_pos + 1]);
          $status = strpos( $version, "4.5.1" ) === false ?
            "WARNING" : "OK";
          ?>
          <td colspan="3">
            <span style="color: <?php echo( $status == "OK" ? "green" : "red" );
              ?>; font-weight: bold;"><?php echo( $status ); ?></span>
            (<?php echo( $version_str ); ?>)&nbsp;
            <?php
            if ($status != "OK") {
              echo( mosWarning(
                "You are running a possibly unsupported version of Mambo."
                  ." This version of Alias Manager is designed ONLY for Mambo 4.5.1.",
                "Unsupported Mambo Version" ) );
            }
            ?>
          </td>
        </tr>
        <tr>
          <td valign="top" align="right" nowrap="1">SEO/SEF URLs Enabled:&nbsp;</td>
          <?php
          // Check if SEF is disabled in Mambo's global configuration
          $status = ($mosConfig_sef != '1') ?
            '<a style="color: red;" href="index2.php?option=com_config">WARNING</a>' : "OK";
          ?>
          <td colspan="3">
            <span style="color: <?php echo( $status == "OK" ? "green" : "red" );
              ?>; font-weight: bold;"><?php echo( $status ); ?></span>
            <?php
            if ($status != "OK") {
              echo( mosWarning(
                "SEO/SEF is currently disabled in Mambo\\'s Global Configuration."
                  ." Alias Manager will NOT function unless you enable it.",
                "SEO/SEF URLs Disabled" ) );
            }
            ?>
          </td>
        </tr>
        <tr>
          <td valign="top" align="right" nowrap="1">File .htaccess Exists:&nbsp;</td>
          <?php
          // Check if htaccess.txt has been correctly renamed to .htaccess
          $htaccess_file = "$mosConfig_absolute_path/.htaccess";
          $status = file_exists( $htaccess_file ) ? "OK" : "WARNING";
          ?>
          <td colspan="3">
            <span style="color: <?php echo( $status == "OK" ? "green" : "red" );
              ?>; font-weight: bold;"><?php echo( $status ); ?></span>
            <?php
            if ($status != "OK") {
              echo( mosWarning(
                "The file $htaccess_file does not exist. Please rename the"
                  ." htaccess.txt provided by Mambo to .htaccess,"
                  ." otherwise Alias Manager will NOT function.",
                "No .htaccess File Found" ) );
            }
            ?>
          </td>
        </tr>
        <tr>
          <td valign="top" align="right" nowrap="1">SEF Hook Installed:&nbsp;</td>
          <?php
          // Check that Alias Manager's configuration file is writable.
          // If it isn't the user can't save any changes to settings.
          $sefhook_file = "$mosConfig_absolute_path/components/com_sef/sef.php";
          $status = file_exists( $sefhook_file ) ? "OK" : "WARNING";
          ?>
          <td colspan="3">
            <span style="color: <?php echo( $status == "OK" ? "green" : "red" );
              ?>; font-weight: bold;"><?php echo( $status ); ?></span>
            <?php
            if ($status != "OK") {
              echo( mosWarning(
                "The file components/com_sef/sef.php does not exist."
                  ." Copy this file from components/com_alias/ to the"
                  ." aforementioned directory.",
                "SEF Hook Not Installed" ) );
            }
            ?>
          </td>
        </tr>
        <tr>
          <td valign="top" align="right" nowrap="1">Configuration Writable:&nbsp;</td>
          <?php
          // Check that Alias Manager's configuration file is writable.
          // If it isn't the user can't save any changes to settings.
          $config_file = "$mosConfig_absolute_path/administrator/components/com_alias/alias.config.php";
          $status = file_exists( $config_file ) && is_writable( $config_file ) ?
            "OK" : "WARNING";
          ?>
          <td colspan="3">
            <span style="color: <?php echo( $status == "OK" ? "green" : "red" );
              ?>; font-weight: bold;"><?php echo( $status ); ?></span>
            <?php
            if ($status != "OK") {
              echo( mosWarning(
                "The file administrator/components/\\ncom_alias/alias.config.php"
                  ." is not writable by the web server."
                  ." You need the change its permissions to 666.",
                "Configuration File Not Writable" ) );
            }
            ?>
          </td>
        </tr>
        <tr>
          <td valign="top" align="right" nowrap="1">Base URL Matches:&nbsp;</td>
          <?php
          // Check if the Alias Base URL matches Mambo's Base URL
          // (Note that the +1 in the line below is intentional, to handle https sites.)
          $mambo_base_url = strchr( substr( $mosConfig_live_site, strlen( "http://" ) + 1 ), "/" );
          $mambo_base_url = $mambo_base_url === false ? "" : $mambo_base_url;
          $status = $mambo_base_url != $config->base_url ?
            "WARNING" : "OK";
          ?>
          <td colspan="3">
            <span style="color: <?php echo( $status == "OK" ? "green" : "red" );
              ?>; font-weight: bold;"><?php echo( $status ); ?></span>
            <?php
            if ($status != "OK") {
              echo( mosWarning(
                "The alias base URL ($config->base_url) doesn\\'t match"
                  ." Mambo\\'s base URL ($mambo_base_url)."
                  ." Please check your settings.",
                "No .htaccess File Found" ) );
            }
            ?>
          </td>
        </tr>
        <tr>
          <td colspan="4">&nbsp;</td>
        </tr>
        </table>
        <?php
        $tabs->endTab();
        $tabs->startTab( "Advanced", "advanced-page" );
        ?>
        <table class="adminform" width="100%">
        <tr>
          <th colspan="4">Smart URLs</th>
        </tr>
        <tr>
          <td valign="top" align="right" nowrap="1">Directory Trailing Slashes:&nbsp;</td>
          <td><?php echo( mosHTML::yesnoSelectList( "config_auto_trailing_slashes",
            'class="inputbox"', $config->auto_trailing_slashes ) ); ?></td>
          <td><?php echo( mosToolTip( "In case an alias cannot be found, check if by"
            . " appending a trailing slash we can get a valid address. If so, redirect"
            . " the browser to that location instead." , "Directory Trailing Slashes" ) ); ?></td>
          <td width="100%">&nbsp;</td>
        </tr>
        <tr>
          <td valign="top" align="right" nowrap="1">Directory Index Pages:&nbsp;</td>
          <td><?php echo( mosHTML::yesnoSelectList( "config_auto_index_pages",
            'class="inputbox"', $config->auto_index_pages ) ); ?></td>
          <td><?php echo( mosToolTip( "If a virtual directory alias, i.e. an address ending with"
            . " a trailing slash, doesn\\'t have an index page, try to automatically append \\'index.html\\'"
            . " to locate a page instead of doing a 404.", "Directory Index Pages" ) ); ?></td>
          <td width="100%">&nbsp;</td>
        </tr>
        <tr>
          <td valign="top" align="right" nowrap="1">Short Component URLs:&nbsp;</td>
          <td><?php echo( mosHTML::yesnoSelectList( "config_auto_short_components",
            'class="inputbox"', $config->auto_short_components ) ); ?></td>
          <td><?php echo( mosToolTip( "Automatically shorten all component URLs from the standard"
            . " Mambo SEF format of /component/option,com_weblinks/... to the simpler /weblinks/...",
            "Short Component URLs" ) ); ?></td>
          <td width="100%">&nbsp;</td>
        </tr>
        <?php /*
        // TODO: Implement this for version 1.1.
        <tr>
          <td valign="top" align="right" nowrap="1">Nearest Matching URLs:&nbsp;</td>
          <td><?php echo( mosHTML::yesnoSelectList( "config_auto_nearest_match",
            'class="inputbox"', $config->auto_nearest_match ) ); ?></td>
          <td><?php echo( mosToolTip( "", "Nearest Matching URLs" ) ); ?></td>
          <td width="100%">&nbsp;</td>
        </tr>
        */ ?>
        <tr>
          <th colspan="4">URL Validation</th>
        </tr>
        <tr>
          <td valign="top" align="right" nowrap="1">URL Validation Level:&nbsp;</td>
          <?php
            $err404_options = array();
            $err404_options[] = mosHTML::makeOption( "0", "None" );     // No checking so anything goes; Mambo default
            $err404_options[] = mosHTML::makeOption( "1", "Normal" );   // Alias lookup, begins with /content, begins with /component
            //$err404_options[] = mosHTML::makeOption( "2", "Strict" );   // Alias lookup, content item exists, begins with /component // v1.1
            $err404_options[] = mosHTML::makeOption( "3", "Lockdown" ); // Alias lookup only
          ?>
          <td><?php echo( mosHTML::selectList( $err404_options, "config_validate_urls", 'class="inputbox"',
            "value", "text", $config->validate_urls ) ); ?></td>
          <td><?php echo( mosToolTip( "Whether and how to validate URLs and redirect the browser to the 404"
            . " Not Found page in case the request URL is invalid. None: anything goes (Mambo\\'s default),"
            . " invalid URLs will go to frontpage; Normal: lookup alias or check whether URLs begin with"
            . " /content or /component; Lockdown: paranoid mode where only aliases and component URLs count"
            . " as valid, anything else gives a 404.", "URL Validation Level" ) ); ?></td>
          <td width="100%">&nbsp;</td>
        </tr>
        <tr>
          <td valign="top" align="right" nowrap="1">404 Not Found URL:&nbsp;</td>
          <td><input name="config_err404_page" type="textbox" class="inputbox" size="10"
            value="<?php echo( $config->err404_page ); ?>" /></td>
          <td nowrap="1"><?php echo( mosToolTip( "Where to redirect the browser in case of a 404 Not Found error."
            . " This can be either a relative (to the Mambo directory) or absolute (including http://) URL.",
            "404 Not Found URL" ) ); ?><?php
            if ($config->validate_urls == '0' && ($config->err404_page != ''
              && $config->err404_page != '/')) {
                echo( "&nbsp;" . mosWarning(
                  "Note that this will have no effect unless you set"
                  ." URL Validation to some other setting than None.",
                "URL Validation Is Disabled" ) ); } ?></td>
          <td width="100%">&nbsp;</td>
        </tr>
        <tr>
          <td colspan="4">
            <input type="button" value="Update Settings" onclick="submitform('config');" />
          </td>
        </tr>
        </table>
        <?php
        $tabs->endTab();
        $tabs->startTab( "Import", "import-page" );
        ?>
        <table class="adminform" width="100%">
        <tr>
          <th colspan="2">Import URLs</th>
        </tr>
        <tr>
          <td colspan="2" valign="top" align="left">
            Use the textbox below to quickly create or import URL aliases.
            Input one alias/target URL combination per line. 
            (<a href="<?php echo( $mosConfig_live_site ); ?>/administrator/components/com_alias/sample.txt"
              target="_blank">Sample Data</a>)
            <?php echo( mosToolTip(
              "Separate the alias URL and target URL using a space."
              . " For example:<br>"
              . " /services.html /content/view/11/23/", "Import URL Help" ) ); ?>
            <textarea name="import_text" cols="20" rows="15" wrap="off"
              style="width: 95%;"></textarea>
          </td>
        </tr>
        <tr>
          <td colspan="2">
            <input name="import_strip" type="checkbox" value="1" checked="1" class="inputbox" />
            Convert target URLs from absolute to relative for this site
            <?php echo( mosToolTip(
              "This option will automatically remove &quot;$mosConfig_live_site&quot;"
              . " from the beginning of target URLs you enter;"
              . " use this unless you are sure you want aliases that cause a browser redirect."
              . " Consult the manual for further details.", "Import URL Conversion" ) ); ?>
          </td>
        </tr>
        <?php
        /*
        // TODO: Implement this in version 1.1.
        <tr>
          <td colspan="2">
            Set alias language to:
            <?php echo( mosToolTip(
              "This option will automatically remove &quot;$mosConfig_live_site&quot;"
              . " from the beginning of target URLs you enter;"
              . " use this unless you are sure you want aliases that cause a browser redirect."
              . " Consult the manual for further details.", "Import URL Conversion" ) ); ?>
          </td>
        </tr>
        */
        ?>
        <tr>
          <td colspan="2">
            <input type="button" value="Import URLs" onclick="submitform('import');" />
          </td>
        </tr>
        <tr>
          <td colspan="2">&nbsp;</td>
        </tr>
        </table>
        <?php
        $tabs->endTab();
        $tabs->startTab( "Tools", "tool-page" );
        ?>
        <table class="adminform" width="100%">
        <tr>
          <th colspan="2">Export to File</th>
        </tr>
        <tr>
          <td colspan="2" valign="top" align="left">
            <select name="export_format">
              <option value="text" selected="1">Text File (suitable for easy reimporting)</option>
              <option value="sql">SQL Dump (full SQL backup of table)</option>
            </select>
          </td>
        </tr>
        <tr>
          <td colspan="2">
            <input type="button" value="Export and Download" onclick="submitform('export');" />
            &nbsp;<?php echo( mosToolTip(
              "You can use this feature to easily backup your Alias Manager data or"
              . " to transfer it to another Mambo installation."
              . " If you are not sure which export format you would like to use,"
              . " you should export to a text file. In general, only advanced users with"
              . " special requirements will need an SQL dump.", "Export to File" ) ); ?>
          </td>
        </tr>
        <tr>
          <td colspan="2">&nbsp;</td>
        </tr>
        <tr>
          <td colspan="2">
            (If the above button doesn't work,
            <a href="<?php echo( $mosConfig_live_site ); ?>/administrator/index2.php?option=com_alias&task=export&export_format=text"
              target="_blank">click here</a>.)
          </td>
        </tr>
        <tr>
          <td colspan="2">&nbsp;</td>
        </tr>
        </table>
        <?php
        $tabs->endTab();
        $tabs->endPane();
        ?>
      </td>
    </tr>
    </table>

    <input type="hidden" name="option" value="<?php echo( $option ); ?>" />
    <input type="hidden" name="task" value="" />
    <input type="hidden" name="boxchecked" value="0" />
    </form>
  <?php
    HTML_alias::printVersion();
  } // function aliasView

  function aliasForm( &$row, $option ) {
    global $mosConfig_live_site;
    mosMakeHtmlSafe( $row, ENT_QUOTES );
    $tabs = new mosTabs( 0 );
    ?>
    <script language="JavaScript" type="text/javascript">
      function submitbutton(pressbutton) {
        var form = document.adminForm;
        if (pressbutton == 'cancel') {
          submitform( pressbutton );
          return;
        }
        // do field validation
        if (form.url.value == '') {
          alert( 'Please fill in the URL Alias field.' );
          return;
        }
        submitform( pressbutton );
      }
    </script>
    <script language="JavaScript" src="<?php echo( $mosConfig_live_site ); ?>/includes/js/overlib_mini.js"></script>
    <div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
    <form action="index2.php" method="post" name="adminForm">

    <table class="adminheading" width="100%">
    <tr>
      <th class="browser">&nbsp;<?php echo( $row->id ? 'Edit' : 'Add' ); ?> Alias</th>
    </tr>
    </table>

    <table class="" width="100%">
    <tr>
      <td width="100%" valign="top">
        <table class="adminform" width="100%">
        <tr>
          <th colspan="3"><?php echo( "Alias Details" ); ?></th>
        </tr>
        <tr>
          <td valign="top" nowrap="1">URL Alias:&nbsp;</td>
          <td valign="top" nowrap="1">
            <input class="inputbox" type="text" size="50"
              name="url" value="<?php echo( $row->url ); ?>" />
          </td>
          <td width="100%" align="left"><?php echo( mosToolTip( "The friendly URL you would like to show"
            . " to your visitors; for example: /about_us/management.html",
            "URL Alias" ) ); ?></td>
        </tr>
        <tr>
          <td valign="top" nowrap="1">URL Target:&nbsp;</td>
          <td valign="top" nowrap="1">
            <input class="inputbox" type="text" size="50"
              name="target" value="<?php echo( $row->target ); ?>" />
          </td>
          <td align="left"><?php echo( mosToolTip( "Where the alias should point to. Input"
            . " an internal URL such as /content/view/1/2 for transparent URL"
            . " mapping, or an external URL (starting with http://) for browser"
            . " redirection.", "URL Target" ) ); ?></td>
        </tr>

        <tr>
          <td valign="top" nowrap="1">Language:&nbsp;</td>
          <td valign="top" nowrap="1">
          <?php
            $alias_langs = array();
            $alias_langs[] = mosHTML::makeOption( "", "(Default)" );
            $alias_langs = array_merge( $alias_langs, HTML_alias::getLanguageList() );
            echo( mosHTML::selectList( $alias_langs, "language",
                'class="inputbox" size="1"', "value", "text", $row->language ) );
          ?>
          </td>
          <td align="left"><?php echo( mosToolTip( "If you change this from (Default) to another"
            . " language, Alias Manager will dynamically change Mambo\\'s frontend language to that"
            . " value when this alias URL is accessed. If you don\\'t see any languages in this dropdown"
            . " list, you will need to install some first.",
            "Language" ) ); ?></td>
        </tr>

        <tr>
          <td colspan="3" align="center">&nbsp;</td>
        </tr>
        <tr>
          <td valign="top" nowrap="1">Published:&nbsp;</td>
          <td valign="top" nowrap="1">
            <?php echo( mosHTML::yesnoSelectList( "published", "class=\"inputbox\"", $row->published ) ); ?>
          </td>
          <td align="left"><?php echo( mosToolTip( "Whether this URL mapping is active or not.",
            "Published" ) ); ?></td>
        </tr>
        <tr>
          <td colspan="3" align="center">&nbsp;</td>
        </tr>

        </table>
      </td>
      <?php
      /*
      // TODO: Implement this for version 1.1.
      <td width="35%" valign="top">
        <?php
        $tabs->startPane( "content-pane" );
        $tabs->startTab( "Target Info", "target-page" );
        ?>
        <table class="adminform" width="100%">
        <tr>
          <th colspan="2">Target Details</th>
        </tr>
        <tr>
          <td colspan="2"><i>This feature is under construction.</i></td>
        </tr>
        <tr>
          <td colspan="2">&nbsp;</td>
        </tr>
        </table>
        <?php
        $tabs->endTab();
        $tabs->endPane();
        ?>
      </td>
      */
      ?>
    </tr>
    </table>

    <input type="hidden" name="id" value="<?php echo( $row->id ); ?>">
    <input type="hidden" name="option" value="<?php echo( $option ); ?>">
    <input type="hidden" name="task" value="">
    </form>
  <?php
    HTML_alias::printVersion();
  } // function aliasForm

} // class HTML_alias

?>