<?php
/** Set flag that this is a parent file */
define( "_VALID_MOS", 1 );

chdir('../../');
if (!file_exists( "../configuration.php" )) {
	header( "Location: ../installation/index.php" );
	exit();
}

require_once( "../globals.php" );
require_once( "../configuration.php" );
require_once( $mosConfig_absolute_path . "/includes/mambo.php" );
include_once( $mosConfig_absolute_path . "/language/".$mosConfig_lang.".php" );
require_once( $mosConfig_absolute_path . "/administrator/includes/admin.php" );
require_once( $mosConfig_absolute_path . "/components/com_mosforms/mosform_parent.class.php" );
require_once( $mosConfig_absolute_path . "/components/com_mosforms/mosform_functions.php" );
require_once( $mosConfig_absolute_path . "/components/com_mosforms/mosform_table.class.php" );
require_once( $mosConfig_absolute_path . "/components/com_mosforms/mosform_connection.class.php" );

$database = new database( $mosConfig_host, $mosConfig_user, $mosConfig_password, $mosConfig_db, $mosConfig_dbprefix );
$database->debug( $mosConfig_debug );
$acl = new gacl_api();

$option = strtolower( mosGetParam( $_REQUEST, 'option', '' ) );
if ($option == '') {
	$option = 'com_admin';
}
// must start the session before we create the mainframe object
session_name( 'mosadmin' );
session_start();

// mainframe is an API workhorse, lots of 'core' interaction routines
$mainframe = new mosMainFrame( $database, $option, '..', true );

// initialise some common request directives
$task = mosGetParam( $_REQUEST, 'task', '' );
$act = strtolower( mosGetParam( $_REQUEST, 'act', '' ) );

$type = mosGetParam( $_REQUEST, 'type', 'form');
$id = mosGetParam( $_REQUEST, 'cid', '');
$format =  mosGetParam( $_REQUEST, 'format', '');

initGzip();
header('Content-Type: text/plain');
if( $format == 'csv' ){
	header('Content-Disposition: attachment; filename="export.csv"');
}else{
	header('Content-Disposition: attachment; filename="export.sql"');
}

if($type == 'form'){
	$sql = "SELECT * FROM #__mosform_formdata_".$form_id;
	$database->setQuery($sql);
	$formdata = $database->loadObjectList();
}else{

	$oTable = new mosForm_Table($database);
	
	$oConn = new mosForm_Connection( $database );
	
	$oTable->load($id);
	
	$oConn->load( $oTable->connection_id );

	$aTable = mosObjectToArray($oTable);

	$mosformDb = $oConn->loadTableConnectionDB();

	$table = $oTable->db_table_name;
	
	$sql = "select * from $table";

	$mosformDb->setQuery($sql);

	$elementData = $mosformDb->loadObjectList();
	
	$aNewDbInfo = switchDatabase($oTable, $option, $oConn);
	
	$mosformDb = $aNewDbInfo[0];

	$table = $aNewDbInfo[1];	
	
	$formdata = $oTable->getElementData($mosformDb, $orderBy, $aOrder, $aFilter);
	

}
		

//echo '<pre>';
//print_r($formdata);
//echo '</pre>';

if (is_array($formdata)) {
	$firstrow = mosObjectToArray($formdata[0]);
	//print_r($firstrow);
	echo implode(",", array_keys($firstrow));

	foreach($formdata as $row){
		echo "\n";
		echo implode(",", array_map("quote", array_values(mosObjectToArray($row))));
	}
}
doGzip();

function quote($n) {
	return "'".addslashes($n)."'";
}
?>