/************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad 10.10                                                      *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#define PI  3.14159265358979324
#define EPS 1e-15

double atan_1(double x) /* szereg zbieny dla |x| < 1 */
{
    double a, kwx, suma;
    int n;
    suma = 0;               /* pocztkowa warto sumy */
    a = x;                  /* pierwszy wyraz szeregu */
    kwx = -x*x;             /* liczba przeciwna do kwadratu x */
    n = 1;                  /* licznik kolejnych wyrazw */
    do {
        suma += a;          /* dodanie wyrazu */
        a = a*(2*n-1)/(2*n+1)*kwx;
        n += 1;             /* nastpny wyraz */
    } while (fabs(a) >= EPS);
    return suma;
}

double atan_2(double x) /* szereg zbieny dla x > 1 */
{
    double a, kwx, suma;
    int n;
    suma = PI/2;        /* pocztkowa warto sumy */
    a = -1.0/x;         /* pierwszy wyraz szeregu */
    kwx = -x*x;         /* liczba przeciwna do kwadratu x */
    n = 1;              /* licznik kolejnych wyrazw */
    do {
        suma += a;                  /* dodanie wyrazu */
        a = a*(2*n-1)/(2*n+1)/kwx;  /* nastpny wyraz */
        n += 1;
    } while (fabs(a) >= EPS);
    return suma;
}

double atan_3(double x) /* szereg zbieny dla x < -1 */
{
    double a, kwx, suma;
    int n;
    suma = -PI/2;       /* pocztkowa warto sumy */
    a = -1.0/x;         /* pierwszy wyraz szeregu */
    kwx = -x*x;         /* liczba przeciwna do kwadratu x */
    n = 1;              /* licznik kolejnych wyrazw */
    do {
        suma += a;                          /* dodanie wyrazu */
        a = a*(double)(2*n-1)/(2*n+1)/kwx;  /* nastpny wyraz */
        n += 1;
    } while (fabs(a) >= EPS);
    return suma;
}

double arctg(double x)
{
    if (x > 1)
        return atan_2(x);
    else if (x == 1)
        return PI/4;
    else if (x == -1)
        return - PI/4;
    else if (x < -1)
        return atan_3(x);
    else return atan_1(x);
}

int main()
{
    system("chcp 1250");
    double x;
    printf("Obliczanie wartoci funkcji arcus tangens x.\n");
    printf("Podanie wartoci x = 0 zakoczy obliczenia.\n");
    do {
        printf("x = ");
        scanf("%lf", &x);
        printf("Suma szeregu - funkcja arctg(x) = %0.15lf\n", arctg(x));
        printf("Funkcja standardowa   arctan(x) = %0.15lf\n", atan(x));
    } while(x != 0);
    system("pause");
    return 0;
}
