/************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad 5.9a                                                       *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>

double pot(double a, int n)
{
    double x = 1;       /* pocztkowa warto potgi, dla n = 0 */
    while (n != 0) {
        if (n%2 == 0)
            a = a*a;    /* wykadnik parzysty */
        else {          /* wykadnik nieparzysty */
            x = x*a;
            a = a*a;
        }
        n /= 2;         /* "poowa" wykadnika */
    }
    return x;
}

double adoen(double a, int n)
{
    if (a == 0 && n <= 0)
        exit(-1); /* symbol nieoznaczony */
    else if (a == 0)
        return 0;   /* 0^n = 0, dla n = 1, 2, 3... */
    else if (a == 1)
        return 1; /* 1^n = 1, dla dowolnego n */
    else {
        if (n < 0) {/* jeli wykadnik jest ujemny... */
            a = 1/a; /* odwrotno podstawy */
            n = -n;  /* zmiana znaku wykadnika */
        }
        /* wywoanie funkcji realizujcej szybkie potgowanie */
        return pot(a, n); /* wynik a ^ n */
    }
}

int main()
{
    system("chcp 1250");
    printf("1^0 = %lf\n", adoen(1, 0));
    printf("0^1 = %lf\n", adoen(0, 1));
    printf("2^3 = %lf\n", adoen(2, 3));
    printf("2^-3 = %lf\n", adoen(2, -3));
    printf("5^-1 = %lf\n", adoen(5, -1));
    printf("1.5^2 = %lf\n", adoen(1.5, 2));
    /* printf("0^0 = %lf\n", adoen(0, 0)); */
    printf("0^-1 = %lf\n", adoen(0, -1)); /* bd! */
    printf("Kolejnego przykadu nie bdzie.\n");
    system("pause");
    return 0;
}
