(************************************************************************
 *  "Od matematyki do programowania. Wszystko co kady programista..."  *
 *  Wiesaw Rychlicki            *            (c) Helion, Gliwice 2011  *
 *  Przykad 9.21a                                                      *
 ************************************************************************)

program p9_21a;

type fraction = record
                  licz: int64;
                  mian: int64;
                end;

function nwd(m, n: int64): int64;
begin
  if (m = n) then nwd := m
             else if m > n then nwd := nwd(m-n, n)
                           else nwd := nwd(n-m, m);
end;

var cf: array[0..42] of fraction;
    u, v: fraction;
    i, n: integer;
    s: int64;

begin
  writeln('Zamiana uamka acuchowego na uamek zwyky.');

  {umieszczenie uamka w tablicy}
  cf[0].licz := 1; {cz cakowita}
  for i := 1 to 42 do
    cf[i].licz := 1; {liczniki}
  for i := 1 to 42 do
    cf[i].mian := 1; {mianowniki}
  for i := 1 to 14 do
    cf[3*i].mian := 2*i; {2, 4, 6, 8}

  n := 41; {maksymalna ilo ogniw do zsumowania}

  {wywietlanie uamka acuchowego}
  write('u = ', cf[0].licz);
  for i := 1 to n - 1 do
    write('+' , cf[i].licz, '/(', cf[i].mian);
  write('+', cf[n].licz, '/', cf[n].mian);
  for i:= 1 to n-1 do write(')');
  writeln;

  {zamiana uamka acuchowego na zwyky}
  v := cf[n];
  for i := n-1 downto 1 do
    begin
      u := v;
      v.licz := cf[i].licz*u.mian;
      v.mian := cf[i].mian*u.mian+u.licz;
      s := nwd(v.licz, v.mian); {skracanie uamka v}
      v.licz := v.licz div s;
      v.mian := v.mian div s;
    end;
  u.mian := v.mian;
  u.licz := cf[0].licz*v.mian+v.licz;

  {wywietlenie wyniku}
  writeln('u = ', u.licz, ' / ', u.mian, ' = ', u.licz/u.mian:0:18);
  writeln('e = ', u.licz/u.mian+1:0:15);
  readln;
end.
