#include <stdio.h>

/* A very simple wrapper.
 * Usage: wrapper program-to-run arguments
 * We'll change to our effective uid/gid and run the program.
 * We completely wipe out the environment when we run the new program.
 * This is safe, but might be annoying - maybe you want TERM preserved
 * or something; see Majordomo's wrapper.c for a more complex wrapper.
 */

int
main(argc, argv)
    int argc;
    char * argv[];
{
    if (argc < 2) {
	fprintf(stderr, "Usage: %s program [<arg> ...]\n", argv[0]);
	exit(1);
    }

    setgid(getegid());
    setuid(geteuid());

    if (execve(argv[1], argv+1, NULL) < 0) {
 	perror("wrapper");
    }
}
