/* rmlist.c - remove a mailing list subscriber file created by mklist
 * by Alan Schwartz 1996
 *
 * Usage: rmlist listname
 * Removes the file called "listname" in LISTDIR, if allowed.
 *
 * If your system can use the sticky bit on directories, you can set
 * LISTDIR to be drwxrwxrwt and rmlist need not be setuid root. Otherwise,
 * LISTDIR should be root-owned, mode 755, and rmlist should be setuid
 * root.
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/stat.h>


int main(argc,argv)
     int argc;
     char *argv[];
{
  struct stat buf;
  int uid;

  if (argc != 2) {
    fprintf(stderr,"Usage: rmlist listname\n");
    exit(1);
  }
  if (chdir(LISTDIR) < 0) {
    fprintf(stderr,"Unable to access %s\n",LISTDIR);
    exit(1);
  }
  uid = getuid();
  if (stat(argv[1],&buf) < 0) {
    fprintf(stderr,"I can't find a list called %s\n",argv[1]);
    exit(1);
  }
  if (buf.st_uid != uid) {
    fprintf(stderr,"That mailing list belongs to someone else.\n");
    exit(1);
  }
  /* Ok, let's delete the file */
  if (unlink(argv[1]) < 0) {
    fprintf(stderr,"Unable to remove %s!\n",argv[1]);
    exit(1);
  }
  fprintf(stderr,"Mailing list %s has been removed.\n",argv[1]);
  exit(0);
}
    
