#!/bin/sh
##########################################################################
#                                                                        #
# This script is for adding lists to Listserv 6.0c. It's a modification  #
# of the add_list.sh script originally written by djbarnes@tx.ncsu.edu   #
# Modified by Alan Schwartz 1996.                                        #
#                                                                        #
##########################################################################

# Set the server user's home directory here.
home=/home/server

# Determine how echo suppresses new-line
echo "a\c" > /tmp/echo
if [ "`grep c /tmp/echo`" = "a\c" ]; then
  n='-n'
  c=''
else
  n=''
  c='\c'
fi
rm /tmp/echo

cd $home

echo "******************************************************************"
echo "This script is used to add lists to the current listserv database."
echo "******************************************************************"
echo ""
echo "This script modifies the following files:"
echo "./owners -- the file that names the owners of each list"
echo "./config -- the config file for listserv"
echo
echo
echo


echo $n "Please enter the name of the list to be added: $c"
read name

capname=`echo $name | tr 'a-z' 'A-Z'`

echo $n "Please enter the email address of the list owner: $c"
read owner

echo $n "Please enter a password for the list (no white space, please): $c"
read password

echo "Please enter a one line comment for the list: "
read comment

echo "What should the default mail mode be (ack, noack, digest): $c"
read mode

echo "Should users be concealed by default (yes or no): $c"
read conceal

echo "What should the default address mode be (fixed or variable): $c"
read addressmode

echo "Should non-subscribers be allowed to mail the list? $c"
read y


echo
echo "The name of the list you entered is: " $name
echo "The email address of the list owner is: " $owner
echo "The password you entered is: " $password
echo "and the comment you entered is: " $comment
echo "The list's mail mode is " $mode
echo "Users are concealed: " $conceal
echo "The list's address mode is " $addressmode
if [ "$y" = "n" -o "$y" = "N" ]; then
  echo "Non-subscribers can't mail the list."
  nonsub=
else
  echo "Non-subscribers can mail the list."
  nonsub=-s
fi
echo


echo $n "Are you sure you want to make those additions? [y] $c"
read y

if [ "$y" = "n" -o "$y" = "N" ]; then
  echo "Nothing changed.  Please Re-run the addlist script to make changes."
  exit 0
else
  echo "Making changes...."
fi

# This line takes care of the owners file
echo $owner $name "CCERRORS" >> owners

# Now the config file
echo "" >> config
echo "#" >> config
echo "#	"$comment >> config
echo "#" >> config
echo "list		"$name $name"@tx.ncsu.edu" $owner $password $nonsub "-P -m 25" >> config
echo "comment		"$name "#"$comment >> config
echo "default "$name " {" >> config
echo "address = " $addressmode >> config
echo "mail = " $mode >> config
echo "conceal = " $conceal >> config
echo "}" >> config
echo 

echo "List addition complete."
echo "*** Add the following alias to your aliases file:"
echo $name": \"|"$home"/catmail -f -L "$capname"\""
echo "***"
echo "If you want this list to be hidden from 'lists' requests, or"
echo "to archive the list, don't forget to edit config"
echo 
echo "Would you like to restart listserv so that the changes take effect?"
echo $n "[y] $c"
read x

if [ "$x" = "n" -o "$x" = "N" ]; then
  echo "Please remember, you must restart listserv for the changes to take effect."
  exit 0
else
  ./start
fi

exit 0


