#!/bin/bash
# ustawia pułapki na określone sygnały, następnie uruchamia skrypt w tle
#
####################### Sprawdza sygnały do przechwycenia #######################
#
while getopts S: opt # sygnały do przechwycenia podawane w opcji -S
do
    case "$opt" in
        S) # znaleziono opcję -S
            signalList="" # ustawienie signalList na null
            #
            for arg in $OPTARG
            do
            case $arg in
            1) # obsługa sygnału SIGHUP
                signalList=$signalList"SIGHUP "
            ;;
            2) # obsługa sygnału SIGINT
                signalList=$signalList"SIGINT "
            ;;
            20) # obsługa sygnału SIGTSTP
                signalList=$signalList"SIGTSTP "
            ;;
            *) # nieznany lub nieobsługiwany sygnał
                echo "Obsługiwane są tylko sygnały 1, 2 i 20."
                echo "Zamykanie skryptu..."
                exit
            ;;
            esac
        done
        ;;
     *) echo 'Użycie: -S "Sygnały" nazwa-skryptu-do-uruchomienia'
        echo 'Zamykanie skryptu...'
        exit
        ;;
    esac
    #
done
#
####################### Sprawdzenie skryptu do uruchomienia #######################
#
shift $[ $OPTIND - 1 ] # nazwa skryptu powinna być przekazana w parametrze
#
if [ -z $@ ]
then
    echo
    echo 'Błąd: nie podano nazwy skryptu.'
    echo 'Użycie: -S "Sygnały" nazwa-skryptu-do-wykonania'
    echo 'Zamykanie skryptu...'
    exit
elif [ -O $@ ] && [ -x $@ ]
then
    scriptToRun=$@
    scriptOutput="$@.out"
else
    echo
    echo "Błąd: $@ nie jest Twoją własnością lub nie jest plikiem wykonywalnym."
    echo "Zamykanie..."
    exit
fi
#
######################### Pułapka i uruchomienie ###########################
#
echo
echo "Wykonywanie skryptu $scriptToRun w tle"
echo "i przechwytywanie sygnałów: $signalList."
echo "Wyniki skryptu zostały wysłane do pliku: $scriptOutput"
echo
trap "" $signalList # ignoruje te sygnały
#
source $scriptToRun > $scriptOutput & # wykonywanie skryptu w tle
#
trap -- $signalList # ustawienie na zachowanie domyślne
#
####################### Koniec skryptu #######################
#
exit