#import <Foundation/Foundation.h>
#import <Security/Security.h>

void example_pki( ) {
    SecKeyRef publicKey;
    SecKeyRef privateKey; 

    CFDictionaryRef keyDefinitions;
    CFTypeRef keys[2];
    CFTypeRef values[2];

    /* Parametry nowej pary kluczy */
    keys[0] = kSecAttrKeyType;
    values[0] = kSecAttrKeyTypeRSA;

    keys[1] = kSecAttrKeySizeInBits;
    int iByteSize = 1024;
    values[1] = CFNumberCreate(NULL, kCFNumberIntType, &iByteSize);

    keyDefinitions = CFDictionaryCreate(
        NULL, keys, values, sizeof(keys) / sizeof(keys[0]), NULL, NULL );

    /* Wygenerowanie nowej pary kluczy */
    OSStatus status = SecKeyGeneratePair(keyDefinitions, 
        &publicKey, &privateKey);

    /* Przykadowe dane uwierzytelniajce wysyane do serwera */
    unsigned char *clearText = "username=USERNAME&password=PASSWORD";
    unsigned char cipherText[1024];
    size_t buflen = 1024;

    /* Szyfrowanie: wykonywane na urzdzeniu */
    status = SecKeyEncrypt(
        publicKey, kSecPaddingNone, clearText, strlen(clearText) + 1, 
        &cipherText[0], &buflen);

    /* Deszyfrowanie: wykonywane na serwerze */
    unsigned char decryptedText[buflen];
    status = SecKeyDecrypt(privateKey, kSecPaddingNone, &cipherText[0],
        buflen, &decryptedText[0], &buflen);
}
