unit DataObject;

interface

uses
  SysUtils, Classes, DBXpress, FMTBcd, Provider,
  DB, SqlExpr, DataPump;

type
  TDataObject = class(TInterfacedObject, IDataPumper)
  private
    { Private declarations }
    FSQLConnection: TSQLConnection;
    FSQLDataSet: TSQLDataSet;
    FDataSetProvider: TDataSetProvider;(**)
  public
    { Public declarations }
    constructor Create;
    destructor Destroy; override;
    function GetIsReady: Boolean;
    function GetData: OleVariant;
    procedure IDataPumper.Initialize = DataPumpInitialize;
    procedure DataPumpInitialize;
  protected
  end;

implementation

constructor TDataObject.Create;
begin
  FSQLConnection := TSQLConnection.Create(nil);
  FSQLDataSet := TSQLDataSet.Create(nil);
  FDataSetProvider := TDataSetProvider.Create(nil);(**)
end;

destructor TDataObject.Destroy;
begin
  FSQLConnection.Free;
  FSQLDataSet.Free;
  FDataSetProvider.Free;
  inherited;
end;

function TDataObject.GetIsReady: Boolean;
begin
  Result := FSQLDataSet.Active;
end;

function TDataObject.GetData: OleVariant;
begin
   Result := FDataSetProvider.Data;
end;

procedure TDataObject.DataPumpInitialize;
begin
with FSQLConnection do
begin
  DriverName :=  'INTERBASE';
  GetDriverFunc := 'getSQLDriverINTERBASE';
  LibraryName := 'libsqlib.so';
  VendorLib := 'libgds.so.0';
  LoadParamsOnConnect := False;
  Params.Add('BlobSize=-1');
  Params.Add('CommitRetain=True');
  Params.Add('Database=' +
  '/usr/local/interbase/examples/employee.gdb');
  with Params do
  begin
    Add('Interbase TransIsolation=ReadCommitted');
    Add('Password=masterkey');
    Add('RoleName=RoleName');
    Add('ServerCharSet=ASCII');
    Add('SQLDialect=1');
    Add('User_Name=sysdba');
    Add('WaitOnLocks=True');
  end; // with Params
  Connected := True;
end; //with FSQLConnection
FSQLDataSet.SQLConnection := FSQLConnection;
FSQLDataSet.CommandText := 'select * from CUSTOMER';
FDataSetProvider.DataSet := FSQLDataSet;
FSQLDataSet.Open;(**)
end;

end.
