unit WebMod;

interface

uses
  Variants, SysUtils, Classes, HTTPApp;

type
  TWebModule1 = class(TWebModule)
    procedure WebModule1WebActionItem1Action(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  WebModule1: TWebModule1;

implementation

uses WebReq;

{$R *.xfm}

procedure TWebModule1.WebModule1WebActionItem1Action(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  i: Integer;
  s: TStringList;
begin
s := TStringList.Create;
with s do
try
  Add('<HTML><HEAD><TITLE>GetOrPost Generated Output');
  Add('</TITLE></HEAD><BODY>');
  Add('<h1>Get or Post CGI Demonstration</h1><P>');
  Add('This request was generated by a ' + Request.Method +
    ' HTTP method.<P>');
  Add('There are ' + IntToStr(Request.QueryFields.Count) +
    ' name-value pairs in the query string.<P>');
  if Request.QueryFields.Count > 0 then
  begin
    Add('These are:<BR>');
    for i := 0 to Pred(Request.QueryFields.Count) do
      Add('&nbsp;&nbsp;' + Request.QueryFields.Strings[i] +
       '<BR><P>');
  end;
  Add('There are ' + IntToStr(Request.ContentFields.Count) +
    ' name-value pairs in the message body.<P>');
  if Request.ContentFields.Count > 0 then
  begin
    Add('These are:<BR>');
    for i := 0 to Pred(Request.ContentFields.Count) do
      Add('&nbsp;&nbsp;' + Request.ContentFields.Strings[i] +
         '<BR><P>');
  end;
  Add('</BODY></HTML>');
  Response.Content := s.Text;
finally
  Free;
end;
end;

initialization
  WebRequestHandler.WebModuleClass := TWebModule1;

end.