unit Main;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QExtCtrls, QComCtrls, QMenus, QTypes;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    Edit1: TEdit;
    Button1: TButton;
    Button2: TButton;
    ListBox1: TListBox;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Close1: TMenuItem;
    PopupMenu1: TPopupMenu;
    DisplayFormMonitor1: TMenuItem;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure DisplayFormMonitor1Click(Sender: TObject);
  private
    { Private declarations }
     Pos : Integer;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses About, Monitor;

{$R *.xfm}


procedure TForm1.Button1Click(Sender: TObject);
begin
if Pos < 0 then
  Pos := ListBox1.ItemIndex;
ListBox1.Items.Insert(Pos, Edit1.Text);
Edit1.Text := '';
ListBox1.ItemIndex := Pos;
Pos := -1;
Edit1.SetFocus;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
if ListBox1.Items.Count > 0 then
    begin
    Pos := ListBox1.ItemIndex;
    Edit1.Text := ListBox1.Items[Pos];
    ListBox1.Items.Delete(Pos);
    end;
Edit1.SetFocus;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
Self.Close;
end;

procedure TForm1.Open1Click(Sender: TObject);
begin
if OpenDialog1.Execute then
  ListBox1.Items.LoadFromFile(OpenDialog1.FileName);
end;

procedure TForm1.Save1Click(Sender: TObject);
begin
if SaveDialog1.Execute then
  if FileExists(SaveDialog1.FileName) then
    if MessageDlg('Replace '+ SaveDialog1.FileName +'?',
      mtInformation, mbOkCancel,0) <> mrOK then
      Exit;
  ListBox1.Items.SaveToFile(SaveDialog1.FileName);
end;

procedure TForm1.Close1Click(Sender: TObject);
begin
ListBox1.Items.Clear;
end;

procedure TForm1.About1Click(Sender: TObject);
begin
AboutBox := TAboutBox.Create(nil);
  try
    AboutBox.ShowModal;
  finally
    AboutBox.Release;
  end;
end;

procedure TForm1.DisplayFormMonitor1Click(Sender: TObject);
begin
with TForm2.Create(Self) do
  Show;
end;

end.
