unit SMTPThread;

interface

uses
  IdThread, Classes;

type
  TSMTPThread = class(TIdThread)
  public
    FFrom: string;
    FMessage: string;
    FRecipient: string;
    FSMTPServer: string;
    FSubject: string;
    procedure Run; override;
  end;

type
  TSyncSendResult = class
  private
    FCmdResult: string;
    procedure ShowResult;
  public
    procedure DoSynchronize(AThread: TIdThread; AMethod: TThreadMethod);
  end;

implementation

uses
  IdMessage, IdSMTP, Main;

procedure TSMTPThread.Run;
var
  LMsg: TIdMessage;
begin
  LMsg := TIdMessage.Create(nil);
  try
    with LMsg do
    begin
      From.Address := FFrom;
      Recipients.Add.Address := FRecipient;
      Subject := FSubject;
      Body.Text := FMessage;
    end; //with LMsg
    with TIdSMTP.Create(nil) do
    try
      Host := FSMTPServer;
      Connect;
      try
        Synchronize(formMain.Connected);
        Send(LMsg);
        with TSyncSendResult.Create do
        try
          FCmdResult := CmdResult;
          DoSynchronize(Self, ShowResult);
        finally
          Free;
        end; //with TSyncSendResult try
      finally
        Disconnect;
      end; //try Synchronize
      Synchronize(formMain.Disconnected);
    finally
      Free;
    end; // with TIdSMPT try
  finally
    LMsg.Free;
  end; // try
  Stop;
end;

procedure TSyncSendResult.DoSynchronize(AThread: TIdThread;
  AMethod: TThreadMethod);
begin
    AThread.Synchronize(AMethod);
end;

procedure TSyncSendResult.ShowResult;
begin
  formMain.Status('Mail accepted ok.');
  formMain.Status('Server said ' + FCmdResult);
end;

end.
