unit Thread;

interface

uses
  Classes, QStdCtrls, SysUtils;

type
  TCounter = class(TThread)
  private
    { Private declarations }
  protected
    Counter: Integer;
    procedure Execute; override;
    procedure DoUpdateLabel;
  public
    CounterLabel: TLabel;
  end;

implementation

{ Important: Methods and properties of objects in CLX can only be used in a
  method called using Synchronize, for example,

      Synchronize(UpdateCaption);

  and UpdateCaption could look like,

    procedure TCounter.UpdateCaption;
    begin
      Form1.Caption := 'Updated in a thread';
    end; }

{ TCounter }

procedure TCounter.DoUpdateLabel;
begin
 CounterLabel.Caption := IntToStr(Counter);
end;

procedure TCounter.Execute;
var
  i: Integer;
begin
for i := 1 to 100 do
begin
  if Self.Terminated then Exit;
  Counter := i;
  Synchronize(DoUpdateLabel);
  Inc(Counter);
end;
end;

end.
