unit datamod;

interface

uses
  SysUtils, Classes, Provider, SqlExpr, DB, DBClient, DBLocal, DBLocalS;

type
  ECustomException = class(Exception);
  EInvalidFieldException = class(ECustomException);

type
  TDataModule2 = class(TDataModule)
    DataSource1: TDataSource;
    SQLClientDataSet1: TSQLClientDataSet;
    SQLConnection1: TSQLConnection;
    SQLClientDataSet1PO_NUMBER: TStringField;
    SQLClientDataSet1CUST_NO: TIntegerField;
    SQLClientDataSet1SALES_REP: TSmallintField;
    SQLClientDataSet1ORDER_STATUS: TStringField;
    SQLClientDataSet1ORDER_DATE: TSQLTimeStampField;
    SQLClientDataSet1SHIP_DATE: TSQLTimeStampField;
    SQLClientDataSet1DATE_NEEDED: TSQLTimeStampField;
    SQLClientDataSet1PAID: TStringField;
    SQLClientDataSet1QTY_ORDERED: TIntegerField;
    SQLClientDataSet1TOTAL_VALUE: TBCDField;
    SQLClientDataSet1DISCOUNT: TFloatField;
    SQLClientDataSet1ITEM_TYPE: TStringField;
    SQLClientDataSet1AGED: TFloatField;
    SQLClientDataSet2: TSQLClientDataSet;
    DataSource2: TDataSource;
    SQLClientDataSet1EMPLOYEE_NAME: TStringField;
    SQLClientDataSet1SUM_TOTAL: TAggregateField;
    SQLClientDataSet1AMOUNT_DUE: TFloatField;
    procedure DataModuleCreate(Sender: TObject);
    procedure SQLClientDataSet1CalcFields(DataSet: TDataSet);
    procedure SQLClientDataSet1DATE_NEEDEDValidate(Sender: TField);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DataModule2: TDataModule2;
{  SALESPO_NUMBER: TStringField;
  SALESCUST_NO: TIntegerField;
  SALESSALES_REP: TSmallintField;
  SALESORDER_STATUS: TStringField;
  SALESORDER_DATE: TSQLTimeStampField;
  SALESSHIP_DATE: TSQLTimeStampField;
  SALESDATE_NEEDED: TSQLTimeStampField;
  SALESPAID: TStringField;
  SALESQTY_ORDERED: TIntegerField;
  SALESTOTAL_VALUE: TBCDField;
  SALESDISCOUNT: TFloatField;
  SALESITEM_TYPE: TStringField;
  SALESAGED: TFloatField;}

implementation

{$R *.xfm}

procedure TDataModule2.DataModuleCreate(Sender: TObject);
begin
{with SQLClientDataSet1 do
begin
  SALESPO_NUMBER :=  FieldByName('PO_NUMBER') as TStringField;
  SALESCUST_NO := FieldByName('CUST_NO') as TIntegerField;
  SALESSALES_REP := FieldByName('SALES_REP') as TSmallintField;
  SALESORDER_STATUS := FieldByName('ORDER_STATUS') as TStringField;
  SALESORDER_DATE := FieldByName('ORDER_DATE') as TSQLTimeStampField;
  SALESSHIP_DATE := FieldByName('SHIP_DATE') as TSQLTimeStampField;
  SALESDATE_NEEDED := FieldByName('DATE_NEEDED') as TSQLTimeStampField;
  SALESPAID := FieldByName('PAID') as TStringField;
  SALESQTY_ORDERED := FieldByName('QTY_ORDERED') as TIntegerField;
  SALESTOTAL_VALUE := FieldByName('TOTAL_VALUE') as TBCDField;
  SALESDISCOUNT := FieldByName('DISCOUNT') as TFloatField;
  SALESITEM_TYPE := FieldByName('ITEM_TYPE') as TStringField;
  SALESAGED := FieldByName('AGED') as TFloatField;
end; }
end;

procedure TDataModule2.SQLClientDataSet1CalcFields(DataSet: TDataSet);
begin SQLClientDataSet1AMOUNT_DUE.Value :=
  SQLClientDataSet1TOTAL_VALUE.Value -
  (SQLClientDataSet1TOTAL_VALUE.Value *
   SQLClientDataSet1DISCOUNT.Value);
end;

procedure TDataModule2.SQLClientDataSet1DATE_NEEDEDValidate(
  Sender: TField);
begin
if Sender.AsDateTime <= Date then
  raise EInvalidFieldException.Create('DATE_NEEDED cannot be prior to today');
end;

end.
