unit dupline;

interface

uses
  SysUtils, Classes {for TShortCut}, QMenus {for ShortCut}, ToolsAPI;

procedure Register;

implementation

type
  TDupLineBinding = class(TNotifierObject, IOTAKeyboardBinding)
  private
  public
    // introduced shortcut
    procedure DupLine(const Context: IOTAKeyContext;
      KeyCode: TShortCut;
      var BindingResult: TKeyBindingResult);
    { IOTAKeyboardBinding }
    function GetBindingType: TBindingType;
    function GetDisplayName: string;
    function GetName: string;
    procedure BindKeyboard(const BindingServices:
      IOTAKeyBindingServices);
  end;

{ TKeyBindingImpl }

function TDupLineBinding.GetBindingType: TBindingType;
begin
  Result := btPartial;
end;

function TDupLineBinding.GetDisplayName: string;
begin
  Result := 'Duplicate Line Binding';
end;

function TDupLineBinding.GetName: string;
begin
  Result := 'jdsi.dupline';
end;

procedure TDupLineBinding.BindKeyboard(
  const BindingServices: IOTAKeyBindingServices);
begin
  BindingServices.AddKeyBinding(
    [ShortCut(Ord('D'), [ssCtrl])], DupLine, nil);
end;

procedure Register;
begin
  (BorlandIDEServices as IOTAKeyboardServices).
    AddKeyboardBinding(TDupLineBinding.Create);
end;

procedure TDupLineBinding.DupLine(const Context: IOTAKeyContext;
  KeyCode: TShortCut; var BindingResult: TKeyBindingResult);
var
  EP: IOTAEditPosition;
  EB: IOTAEditBlock;
  r,c: Integer;
begin
  try

  EP := Context.EditBuffer.EditPosition;
  EP.Save;
  //Save current cursor position
  r := EP.Row;
  c := EP.Column;
  EB := Context.EditBuffer.EditBlock;
  EP.MoveBOL;
  EB.Reset;
  EB.BeginBlock;
  EB.Extend(EP.Row+1,1);
  EB.EndBlock;
  EB.Copy(False);
  EP.MoveBOL;
  EP.Paste;
  //Restore cursor position
  EP.Move(r, c);
  finally
    EP.Restore;
  end;
  BindingResult := krHandled;
end;

end.

