unit DataMod;

interface

uses
  SysUtils, Classes, DBXpress, FMTBcd, Provider,
  DB, SqlExpr, QDialogs, DataPump;

type
  TDataModule3 = class(TDataModule, IDataPumper)
    SQLConnection1: TSQLConnection;
    SQLDataSet1: TSQLDataSet;
    DataSetProvider1: TDataSetProvider;
  private
    { Private declarations }
    //Used for reference counting by _AddRef and _Release
    FRefCount: Integer;
  public
    { Public declarations }
    function GetIsReady: Boolean;
    function GetData: OleVariant;
    procedure Initialize;
  protected
    //Reintroduce _AddRef and _Release
    function _AddRef: Integer; stdcall;
    function _Release: Integer; stdcall;
  end;

var
  DataModule3: TDataModule3;

implementation

{$R *.xfm}

function TDataModule3.GetIsReady: Boolean;
begin
  Result := SQLDataSet1.Active;
end;

function TDataModule3.GetData: OleVariant;
begin
  Result := DataSetProvider1.Data;
end;

procedure TDataModule3.Initialize;
begin
  SQLDataSet1.Open;
end;

function TDataModule3._AddRef: Integer;
begin
  Result := InterlockedIncrement(FRefCount);
end;

function TDataModule3._Release: Integer;
begin
  Result := InterlockedDecrement(FRefCount);
  if Result = 0 then
    Destroy;
end;

end.
