unit WebMod;

interface

uses
  Variants, SysUtils, Classes, HTTPApp, HTTPProd;

type
  TWebModule1 = class(TWebModule)
    PageProducer1: TPageProducer;
    procedure WebModule1InfoActionAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule1WriteCookieActionAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  WebModule1: TWebModule1;

implementation

uses WebReq;

{$R *.xfm}

procedure TWebModule1.WebModule1InfoActionAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  InfoList: TStringList;
  CookieList: TStringList;
  CookieString: String;
  NumVisits: Integer;
  SurferName: String;

  //local function to parse multi-value cookies
  function GetNextStringValue(var TheString: String;
    const Delimiter: String): String;
  var
    DelimiterPosition: Integer;
  begin
    Result := '';
    DelimiterPosition := System.Pos(Delimiter,TheString);
    if DelimiterPosition > 0 then
    begin
      Result := Copy(TheString,1,DelimiterPosition-1);
      System.Delete(TheString,1,DelimiterPosition);
    end
    else
    begin
      Result := TheString;
      TheString := '';
    end;
  end;
label redir, continue;
begin
NumVisits := 0;
if Request.CookieFields.Count > 0 then
  begin
  CookieString := Request.CookieFields.Values['Info'];
  if CookieString = '' then
    goto redir;
  NumVisits := StrToInt(GetNextStringValue(CookieString,':'));
  SurferName := GetNextStringValue(CookieString,':');
  goto continue;
  end
else
  begin
  redir:
    //No cookie found. Send the user to the login page
    Response.SendRedirect('http://localhost/cgi-bin/'+
      'CookiesCGI/Login')
  end;
continue:
InfoList := TStringList.Create;
try
  //Load the InfoList with Request information
  case NumVisits of
    0      : InfoList.Add('<H1>Welcome first time visitor.</H1>');
    1..10  : InfoList.Add('<H1>Welcome back '+
      SurferName+'.  You have visited this site '+
        IntToStr(NumVisits + 1)+ ' times.</H1>');
    11..High(Integer): InfoList.Add('<H1>Dear '+
      SurferName+'. Thank you for returning once more. '+
       'You have visited this site '+IntToStr(NumVisits + 1)+
       ' times.</H1>');
  end;
  InfoList.Add('<h2>Information available to a '+
    'web action.</H2><BR>');
  InfoList.Add('<B>Accept: </B>'+Request.Accept+'</BR>');
  InfoList.Add('<B>Authorization: </B>'+
    Request.Authorization+'<BR>');
  InfoList.Add('<B>Cache Control: </B>'+
    Request.CacheControl+'<BR>');
  InfoList.Add('<B>Connection: </B>'+
    Request.Connection+'<BR>');
  InfoList.Add('<B>Content: </B>'+Request.Content+'<BR>');
  InfoList.Add('<B>Content Fields:</B><BR>');
  InfoList.AddStrings(Request.ContentFields);
  if Request.ContentFields.Count > 0 then
    InfoList.Add('<BR>');
  InfoList.Add('<B>Cookie: </B>'+Request.Cookie+'<BR>');  
  InfoList.Add('<B>Cookie Fields:</B><BR>');
  InfoList.AddStrings(Request.CookieFields);
  if Request.CookieFields.Count > 0 then
    InfoList.Add('<BR>');
  InfoList.Add('<B>Date: </B>'+DateToStr(Request.Date)+'<BR>');
  InfoList.Add('<B>Derived from: </B>'+
    Request.DerivedFrom+'<BR>');
  InfoList.Add('<B>Expires: </B>'+
    DateToStr(Request.Expires)+'<BR>');
  InfoList.Add('<B>From: </B>'+Request.From+'<BR>');
  InfoList.Add('<B>Host: </B>'+Request.Host+'<BR>');
  InfoList.Add('<B>Cache Control: </B>'+
    Request.CacheControl+'<BR>');
  InfoList.Add('<B>IfModifiedSince: </B>'+
    DateToStr(Request.IfModifiedSince)+'<BR>');
  InfoList.Add('<B>Method: </B>'+Request.Method+'<BR>');
  InfoList.Add('<B>PathInfo: </B>'+Request.PathInfo+'<BR>');
  InfoList.Add('<B>PathTranslated: </B>'+
    Request.PathTranslated+'<BR>');
  InfoList.Add('<B>Protocol Version: </B>'+
    Request.ProtocolVersion+'<BR>');
  InfoList.Add('<B>Query: </B>'+Request.Query+'<BR>');
  InfoList.Add('<B>Query Fields:</B><BR>');
  InfoList.AddStrings(Request.QueryFields);
  if Request.QueryFields.Count > 0 then
    InfoList.Add('<BR>');
  InfoList.Add('<B>Referer: </B>'+Request.Referer+'<BR>');
  InfoList.Add('<B>Remote Addr: </B>'+
    Request.RemoteAddr+'<BR>');
  InfoList.Add('<B>Remote Host: </B>'+
    Request.RemoteHost+'<BR>');
  InfoList.Add('<B>Script Name: </B>'+
    Request.ScriptName+'<BR>');
  InfoList.Add('<B>Server Port: </B>'+
    IntToStr(Request.ServerPort)+'<BR>');
  InfoList.Add('<B>Title: </B>'+Request.Title+'<BR>');
  InfoList.Add('<B>URL: </B>'+Request.URL+'<BR>');
  InfoList.Add('<B>User Agent: </B>'+
    Request.UserAgent+'<BR>');
  //Add some fields to a cookie
  CookieList := TStringList.Create;
  try
    CookieList.Add('Info='+IntToStr(NumVisits+1)+
      ':'+SurferName);
    Response.SetCookieField(CookieList,'',
      '/cgi-bin/CookiesCGI',Date + 365,False);
    //Copy the contents of InfoList to the
    //Response.Content property
    Response.Content := InfoList.Text;
    //Cleanup
  finally
    CookieList.Free;
  end; //try
finally
  //final cleanup
  InfoList.Free;
end; //try
end;

procedure TWebModule1.WebModule1WriteCookieActionAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
var
  CookieList: TStringList;
  SurferName: String;
begin
SurferName := Request.QueryFields.Values['Name'];
if SurferName = '' then
//  Response.SendRedirect('http://localhost/cgi-bin/'+
//    'CookiesCGI/Login')
else
begin
  CookieList := TStringList.Create;
  try
    CookieList.Add('Info=0:'+SurferName);
    //Add your domain to the second parameter below
     Response.SetCookieField(CookieList,'',
       '/cgi-bin/CookiesCGI',Date + 365,False);
     Response.Content := 'Welcome '+ SurferName +
       '. You can now enter '+
       'the site. Click the following '+
       '<A HREF="http://localhost/cgi-bin/'+
       'CookiesCGI/ShowInfo">link</A> to enter.';
  finally
    CookieList.Free;
  end;
end;
end;

initialization
  WebRequestHandler.WebModuleClass := TWebModule1;

end.