unit main;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs, TypInfo,
  DBXpress, FMTBcd, QGrids, QDBGrids, Provider, DBClient, DB, SqlExpr,
  QStdCtrls, QExtCtrls, QDBCtrls, DBLocal, DBLocalS;

type
  TForm1 = class(TForm)
    SQLConnection1: TSQLConnection;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    SQLClientDataSet1: TSQLClientDataSet;
    DBNavigator1: TDBNavigator;
    procedure DBGrid1TitleClick(Column: TColumn);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.xfm}

function SortCustomClientDataSet(DataSet: TCustomClientDataSet;
  const FieldName: String): Boolean;
var
  i: Integer;
  IndexDefs: TIndexDefs;
  IndexName: String;
  IndexOptions: TIndexOptions;
begin
Result := False;
if IsPublishedProp(DataSet, 'IndexDefs') then
  IndexDefs := GetObjectProp(DataSet, 'IndexDefs') as TIndexDefs
else
  Exit;
if IsPublishedProp(DataSet, 'IndexName') then
  IndexName := GetStrProp(DataSet, 'IndexName')
else
  Exit;
IndexDefs.Update;
if DataSet.Fields.FindField(FieldName) = nil then Exit;
if IndexName = FieldName + '__IdxA'
then
  begin
    IndexName := FieldName + '__IdxD';
    IndexOptions := [ixDescending];
  end
else
  begin
    IndexName := FieldName + '__IdxA';
    IndexOptions := [];
  end;
for i := 0 to Pred(IndexDefs.Count) do
begin
  if IndexDefs[i].Name = IndexName then
    begin
      Result := True;
      Break
    end;  //if
end; // for
if not Result then
    begin
      DataSet.AddIndex(IndexName, FieldName,IndexOptions);
  //    IndexDefs.Add(IndexName, FieldName,IndexOptions);
      Result := True;
    end; // if not
SetStrProp(DataSet, 'IndexName',  IndexName);
end;


procedure TForm1.DBGrid1TitleClick(Column: TColumn);
begin
  SortCustomClientDataset(SQLClientDataSet1,Column.FieldName);
end;

end.
