unit Main;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ThreadDone(Sender: TObject);
  end;

var
  Form1: TForm1;

implementation

uses Thread;

{$R *.xfm}

var
  Counter1: TCounter;

procedure TForm1.Button1Click(Sender: TObject);
begin
Counter1 := TCounter.Create(True);
with Counter1 do
begin
  Button1.Enabled := False;
  Button2.Enabled := True;
  Button3.Enabled := True;
  OnTerminate := ThreadDone;
  CounterLabel := Label1;
  Resume;
end;
end;

procedure TForm1.ThreadDone(Sender: TObject);
begin
  Button1.Enabled := True;
  Button2.Enabled := False;
  Button3.Enabled := False;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
if Counter1.Suspended then
begin
  Button2.Caption := 'Suspend';
  Counter1.Resume;
end
else
begin
  Counter1.Suspend;
  Button2.Caption := 'Resume';
end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
Counter1.Terminate;
if Counter1.Suspended then
  Counter1.Resume;
end;

end.
