unit WebMod;

interface

uses
  Variants, SysUtils, Classes, HTTPApp, HTTPProd;

type
  TWebModule1 = class(TWebModule)
    PageProducer3: TPageProducer;
    PageProducer1: TPageProducer;
    PageProducer2: TPageProducer;
    procedure WebModule1WebActionItem1Action(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure PageProducer1HTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure WebModule1WebActionItem2Action(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure PageProducer2HTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
  private
    { Private declarations }
    FWebRequest: TWebRequest;
  public
    { Public declarations }
  end;

var
  WebModule1: TWebModule1;

implementation

uses WebReq;

{$R *.xfm}

procedure TWebModule1.WebModule1WebActionItem1Action(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
Response.Content := 'Here it is';
end;

procedure TWebModule1.PageProducer1HTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
begin
if TagString = 'GETTIME' then
  ReplaceText := DateToStr(Date);
end;

procedure TWebModule1.WebModule1WebActionItem2Action(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  FWebRequest := Request;
  Response.Content := PageProducer2.Content;
end;

procedure TWebModule1.PageProducer2HTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
begin
if TagString = 'CUSTTAG' then
  ReplaceText := FWebRequest.QueryFields.Values['cust'];
end;

initialization
  WebRequestHandler.WebModuleClass := TWebModule1;

end.