library kylixsotest;

{ Important note about shared object exception handling:  In 
  order for exception handling to work across multiple modules, 
  ShareExcept must be the first unit in your library's USES 
  clause AND your project's (select Project-View Source) USES 
  clause if 1) your project loads (either directly or indirectly) 
  more than one Kylix-built shared object, and 2) your project or 
  the shared object are not built with runtime packages (baseclx).
  ShareExcept is the interface unit to the dynamic exception 
  unwinder (libunwind.so.6), which must be deployed along with 
  your shared object. }

uses
  SysUtils,
  Classes;

{$SONAME 'libkylixsotest.so'}
{$SOVERSION '1.3'}

procedure ProperCase(TheString: PChar;
  const Delimiters: PChar); cdecl;
{
Converts a null-terminated string to proper case. Proper case
is where the first letter of each word is capitalized.
 }
var
  Delimiter:  Boolean;
  DelimiterList: String;
  i:          Integer;
  s:          String;
begin
  s := TheString;
  if Length(s) = 0 then Exit;
  DelimiterList := Delimiters;
  Delimiter := True;
  for i := 1 to Length(s) do
    if IsDelimiter(DelimiterList, s, i) then
      Delimiter := True
    else
      if Delimiter then
      begin
        if s[i] in ['a'..'z'] then
          Dec(s[i], 32);
        Delimiter := False;
      end
      else
        if s[i] in ['A'..'Z'] then
          Inc(s[i], 32);
  StrPCopy(TheString,s);
end;

exports ProperCase name 'ProperCase';

begin
end.
