unit Main;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  DB, DBClient, QStdCtrls, QGrids, QDBGrids, QExtCtrls, QDBCtrls;

type
  TForm1 = class(TForm)
    ClientDataSet1: TClientDataSet;
    DataSource1: TDataSource;
    DBNavigator1: TDBNavigator;
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    ClientDataSet1ID: TIntegerField;
    ClientDataSet1Name: TStringField;
    ClientDataSet1Address1: TStringField;
    ClientDataSet1Address2: TStringField;
    ClientDataSet1City: TStringField;
    ClientDataSet1Country: TStringField;
    ClientDataSet1PostalCode: TStringField;
    ClientDataSet1PhoneNo: TStringField;
    ClientDataSet1Status: TStringField;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ClientDataSet1CalcFields(DataSet: TDataSet);
    procedure Button4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses ChangeLog;

{$R *.xfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
ClientDataSet1.FileName := ExtractFilePath(Application.ExeName) +
  'addresses.xml';
if not FileExists(ClientDataSet1.FileName) then
  ClientDataSet1.CreateDataSet
else
  ClientDataSet1.Open;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
if ClientDataSet1.ChangeCount = 0 then
  ShowMessage('The change log is empty')
else
begin
  Form2 := TForm2.Create(self);
  try
    Form2.ClientDataSet1.Data := ClientDataSet1.Delta;
    Form2.ShowModal;
  finally
    Form2.Release;
  end;
end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
ClientDataSet1.MergeChangeLog;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
ClientDataSet1.CancelUpdates;
end;

procedure TForm1.ClientDataSet1CalcFields(DataSet: TDataSet);
begin
if ClientDataSet1Status.Visible then
begin
  case ClientDataSet1.UpdateStatus of
    usModified: ClientDataSet1Status.Value := 'Modified';
    usInserted: ClientDataSet1Status.Value := 'Inserted';
    usDeleted:  ClientDataSet1Status.Value := 'Deleted';
    usUnModified: ClientDataSet1Status.Value := 'Unmodified';
  end;
end;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
if Button4.Caption = 'View Changed Records' then
begin
  ClientDataSet1Status.Visible := True;
  DBGrid1.Columns[0].Visible := True;
  ClientDataSet1.StatusFilter := [usModified, usInserted, usDeleted];
  Button4.Caption := 'View All Records';
end
else
begin
  ClientDataSet1Status.Visible := False;
  DBGrid1.Columns[0].Visible := False;
  ClientDataSet1.StatusFilter := [];
  Button4.Caption := 'View Changed Records';
end;
end;

end.
