unit main;

interface

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QGrids, QDBGrids, QDBCtrls, QComCtrls, QExtCtrls, Variants,
  Provider, SqlExpr, DB, DBClient, DBLocal, DBLocalS, DBXpress;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    DBNavigator1: TDBNavigator;
    DBGrid1: TDBGrid;
    Label1: TLabel;
    Label2: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Button1: TButton;
    SQLConnection1: TSQLConnection;
    SQLClientDataSet1: TSQLClientDataSet;
    DataSource1: TDataSource;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.xfm}

procedure TForm1.Button1Click(Sender: TObject);
var
  SearchList: Variant;
begin
if (Edit1.Text = '') and (Edit2.Text = '') then
  begin
    StatusBar1.SimpleText := 'No search values specified';
    Exit
  end
else
if (Edit1.Text <> '') and (Edit2.Text = '') then
   if SQLClientDataSet1.Locate('CUST_NO',Edit1.Text,[]) then
     StatusBar1.SimpleText := 'Found at record ' +
       IntToStr(SQLClientDataSet1.RecNo)
   else
     StatusBar1.SimpleText := 'Not found'
else
if (Edit1.Text = '') and (Edit2.Text <> '') then
  if SQLClientDataSet1.Locate('SALES_REP',Edit2.Text,[]) then
     StatusBar1.SimpleText := 'Found at record '+IntToStr(SQLClientDataSet1.RecNo)
   else
     StatusBar1.SimpleText := 'Not found'
else
  begin
//  This is one alternative. The second alternative follows.
//  SearchList := VarArrayCreate([0,1], VarVariant);
//  SearchList[0] := Edit1.Text;
//  SearchList[1] := Edit2.Text;
    SearchList := VarArrayOf([Edit1.Text,Edit2.Text]);
    if SQLClientDataSet1.Locate('CUST_NO;SALES_REP',SearchList,[]) then
     StatusBar1.SimpleText := 'Found at record '+IntToStr(SQLClientDataSet1.RecNo)
    else
     StatusBar1.SimpleText := 'Not found';
  end;
end;

end.
