unit Main;

interface

uses
  SysUtils, Types, Classes, Variants, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls;

  type
    IShowMessage = interface(IInterface)
    ['{581B2AE2-2821-D511-9EA7-0050569D000A}']
      function ShowMessage:Boolean;
      function GetMessageText: String;
      procedure SetMessageText(Value: String);
      property MessageText: String read GetMessageText
      write SetMessageText;
    end;
    TYesDefault = class(TInterfacedObject, IShowMessage)
      FMessageText: String;
      function ShowMessage: Boolean;
      function GetMessageText: String;
      procedure SetMessageText(value: String);
    public
      destructor Destroy; override;
    end;
    TNoDefault = class(TInterfacedObject, IShowMessage)
      FMessageText: String;
      function ShowMessage: Boolean;
      function GetMessageText: String;
      procedure SetMessageText(value: String);
    public
    destructor Destroy; override;
    end;
    TClassProperty = class(TComponent, IShowMessage)
      FMyMessage: TYesDefault;
      procedure SayHello;
      property MyMessage: TYesDefault read FMyMessage
      write FMyMessage implements IShowMessage;
    end;
    TInterfaceProperty = class(TComponent, IShowMessage)
      FMyMessage: IShowMessage;
      procedure SayHello;
      property MyMessage: IShowMessage read FMyMessage
      write FMyMessage implements IShowMessage;
    end;
    TForm1 = class(TForm)
      Button2: TButton;
      Button1: TButton;
      Button3: TButton;
      Button4: TButton;
      procedure Button2Click(Sender: TObject);
      procedure Button1Click(Sender: TObject);
      procedure Button3Click(Sender: TObject);
      procedure Button4Click(Sender: TObject);
    private
      { Private declarations }
    public
      { Public declarations }
    end;

var
Form1: TForm1;

implementation

{$R *.xfm}

destructor TYesDefault.Destroy;
begin
  QDialogs.ShowMessage('YesDefault: Goodbye');
  inherited;
end;

destructor TNoDefault.Destroy;
begin
  QDialogs.ShowMessage('NoDefault: Goodbye');
  inherited;
end; (**)

function TYesDefault.GetMessageText: String;
begin
  Result := FMessageText;
end;

procedure TYesDefault.SetMessageText(value: String);
begin
  FMessageText := Value;
end;

function TYesDefault.ShowMessage;
begin
if MessageDlg(FMessageText, mtInformation,
  mbOkCancel,0,mbOK) = mrOk then
  Result := True
else
  Result := False;
end;

function TNoDefault.GetMessageText: String;
begin
  Result := FMessageText;
end;

procedure TNoDefault.SetMessageText(value: String);
begin
  FMessageText := Value;
end;

function TNoDefault.ShowMessage;
begin
if MessageDlg(FMessageText, mtInformation,
  mbOkCancel,0,mbCancel) = mrOk then
  Result := True
else
  Result := False;
end;

procedure TClassProperty.SayHello;
begin
ShowMessage('I am an object that implements an interface'+
  ' by delegating to a class property');
end;
procedure TInterfaceProperty.SayHello;
begin
ShowMessage('I am an object that implements an interface'+
  'by delegating to an interface property');
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  Mes1: TYesDefault;
  Mes2: TNoDefault;
begin
  Mes1 := TYesDefault.Create;
  Mes2 := TNoDefault.Create;
  Mes1.SetMessageText('This is a TYesDefault');
  Mes1.ShowMessage;
  Mes2.SetMessageText('This is a TNoDefault');
  Mes2.ShowMessage;
  Mes1.Free;
  Mes2.Free;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  IntVar: IShowMessage;
begin
  IntVar := TYesDefault.Create;
  IntVar.MessageText := 'This is a TYesDefault';
  IntVar.ShowMessage;
  IntVar := TNoDefault.Create;
  IntVar.MessageText := 'This is a TNoDefault';
  IntVar.ShowMessage;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  IntVar: IShowMessage;
  ClassProperty1: TClassProperty;
  YesDefault1 : TYesDefault;
begin
  YesDefault1 := TYesDefault.Create;
  ClassProperty1 := TClassProperty.Create(Self);
  ClassProperty1.SayHello;
  ClassProperty1.MyMessage := YesDefault1;
  IntVar := ClassProperty1;
  IntVar.MessageText := 'Message Text';
  IntVar.ShowMessage;
end;

procedure TForm1.Button4Click(Sender: TObject);
var
  IntVar: IShowMessage;
  InterfaceProperty1: TInterfaceProperty;
  NoDefault1 : TNoDefault;
begin
  NoDefault1 := TNoDefault.Create;
  InterfaceProperty1 := TInterfaceProperty.Create(Self);
  InterfaceProperty1.SayHello;
  InterfaceProperty1.MyMessage := NoDefault1;
  IntVar := InterfaceProperty1;
  IntVar.MessageText := 'Message Text';
  IntVar.ShowMessage;
end;

end.
