unit QFloatingPanel;

interface

uses
  SysUtils, Types, Classes, QGraphics, QControls, QForms, QDialogs,
  QExtCtrls;

type
  TFloatingPanel = class; //forward declaration
  TBeforeFloatEvent = procedure (Sender: TFloatingPanel;
    var NewLeft, NewTop: Integer; var CanFloat: Boolean) of object;
  TFloatingPanel = class(TPanel)
  private
    Fx, Fy: Integer;
    FFloating: Boolean;
    FAfterFloat: TNotifyEvent;
    FBeforeFloat: TBeforeFloatEvent;
    { Private declarations }
  protected
    { Protected declarations }
    function GetAlign: TAlign;
    procedure MouseDown(Button: TMouseButton;
       Shift: TShiftState; X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState;
       X, Y: Integer); override;
    procedure SetAlign(Value: TAlign);
    procedure SetFloating(Value: Boolean);
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  published
    { Published declarations }
    property Align: TAlign read GetAlign write SetAlign;
    property Floating: Boolean read FFloating
       write FFloating default True;
    property AfterFloat: TNotifyEvent read FAfterFloat write FAfterFloat;
    property BeforeFloat: TBeforeFloatEvent
      read FBeforeFloat write FBeforeFloat;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TFloatingPanel]);
end;

{ TFloatingPanel }

constructor TFloatingPanel.Create(AOwner: TComponent);
begin
  inherited;
  Floating := True;
  ControlStyle := ControlStyle - [csSetCaption];
end;

function TFloatingPanel.GetAlign: TAlign;
begin
  Result := inherited Align;
end;

procedure TFloatingPanel.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  inherited;
  Fx := X;
  Fy := Y;
end;

procedure TFloatingPanel.MouseMove(Shift: TShiftState; X, Y: Integer);
var
  NewLeft, NewTop: Integer;
  CanFloat: Boolean;
begin
  inherited;
  if (Align = alNone) and Floating and (ssLeft in Shift) then
  begin
    CanFloat := True;
    NewLeft := Left- Fx + X;
    NewTop := Top- Fy + Y;
    if Assigned(FBeforeFloat) then
      FBeforeFloat(Self, NewLeft, NewTop, CanFloat);
      //Abort the process is CanFloat is False;
      if not CanFloat then Exit;
    {Move object to the new coordinates}
    SetBounds(NewLeft, NewTop, Width, Height);
    if Assigned(FAfterFloat) then FAfterFloat(Self);
  end;
end;

procedure TFloatingPanel.SetAlign(Value: TAlign);
begin
  if (Value <> alNone) and (Floating) then
    FFloating := False;
  inherited Align := Value;
end;

procedure TFloatingPanel.SetFloating(Value: Boolean);
begin
  if Value and (inherited Align <> alNone) then
    inherited Align := alNone;
  FFloating := Value;
end;


end.
